
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * FQTV ALLIANCE- AIRLINE PARTICIPANTS representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceAirlinePartyType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AirlineID"/>
 *         &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceAirlinePartyType extends AssociatedObjectBaseType
    implements Serializable
{
    private AirlineIDType airlineID;
    private String programName;

    /** 
     * Get the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'ProgramName' element value. Airline-sponsored FQTV Program name.  Example: Miles and More
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. Airline-sponsored FQTV Program name.  Example: Miles and More
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }
}
