
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRLINE ALLIANCE PROGRAM Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlliancePreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Alliance" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Alliance -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AlliancePreferencesType extends AssociatedObjectBaseType implements
    Serializable
{
    private List<Alliance> allianceList = new ArrayList<Alliance>();

    /** 
     * Get the list of 'Alliance' element items.
     * 
     * @return list
     */
    public List<Alliance> getAllianceList() {
        return allianceList;
    }

    /** 
     * Set the list of 'Alliance' element items.
     * 
     * @param list
     */
    public void setAllianceList(List<Alliance> list) {
        allianceList = list;
    }
    /** 
     * Used to specify the alliance CodeSet. Refer to IATA PADIS Code List for data element 9906.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Alliance" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CodesetType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:CodesetType" name="GeoIndicatorType" minOccurs="0"/>
     *           &lt;xs:element type="ns:CodesetType" name="FlightHaulLength" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Alliance extends CodesetType implements Serializable
    {
        private CodesetType geoIndicatorType;
        private CodesetType flightHaulLength;
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @return value
         */
        public CodesetType getGeoIndicatorType() {
            return geoIndicatorType;
        }

        /** 
         * Set the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @param geoIndicatorType
         */
        public void setGeoIndicatorType(CodesetType geoIndicatorType) {
            this.geoIndicatorType = geoIndicatorType;
        }

        /** 
         * Get the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @return value
         */
        public CodesetType getFlightHaulLength() {
            return flightHaulLength;
        }

        /** 
         * Set the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @param flightHaulLength
         */
        public void setFlightHaulLength(CodesetType flightHaulLength) {
            this.flightHaulLength = flightHaulLength;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
    }
}
