
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * AUGMENTATION BASE TYPE definition.NDC Capability Model: AUGMENTATION POINT

 ============
 Feature(s)
 ============
 • Within an NDC message document, there may be additional data that needs to be exchanged that is not defined in the NDC Digest as it is unique to an NDC implementer and their trading partners. For example, there are data elements within the NDC message payload that may subject to corporate data collection, management and dissemination policy(s), such as PCI. 

 • Augmentation is the mechanism prescribed by NDC to create a new implementer-derived type, via the extension of an existing NDC Augmentation type—by adding a block of elements bundled together in another type called an "augmentation type." Augmentation objects explicitly show that data is just attached to an object without making a special version of that object. The end result is more like an object with bags of elements rather than a special type of object.

 • Augmentation Point objects are substitution groups with two member elements:
 1) A pre-defined (default) representation provided by NDC; and,
 2) An AugmentationPoint element that may be substituted with a custom implementer type.

 • Within in augmentation point, the processContents attribute is set to "lax", meaning that XML processors will attempt to obtain the schema for the required namespaces and validate any element from those namespaces; however, if the schema cannot be obtained, no errors will occur.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugmentationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Augmentations" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Augmentations -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AugmentationType implements Serializable
{
    private List<Augmentations> augmentationList = new ArrayList<Augmentations>();

    /** 
     * Get the list of 'Augmentations' element items.
     * 
     * @return list
     */
    public List<Augmentations> getAugmentationList() {
        return augmentationList;
    }

    /** 
     * Set the list of 'Augmentations' element items.
     * 
     * @param list
     */
    public void setAugmentationList(List<Augmentations> list) {
        augmentationList = list;
    }
    /** 
     * Augmentation(s).

    Notes: The processContents attribute is set to "lax", meaning that XML processors will attempt to obtain the schema for the required namespaces and validate any element from those namespaces; however, if the schema cannot be obtained, no errors will occur.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Augmentations" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:any processContents="lax"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Augmentations implements Serializable
    {
        private Element any;
        private String refs;

        /** 
         * Get the any value. Augmented Metadata.
         * 
         * @return value
         */
        public Element getAny() {
            return any;
        }

        /** 
         * Set the any value. Augmented Metadata.
         * 
         * @param any
         */
        public void setAny(Element any) {
            this.any = any;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
