
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Baggage Allowance by Description.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAllowanceDescType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="ApplicableParty"/>
 *         &lt;xs:element type="xs:string" name="ApplicableBag" minOccurs="0"/>
 *         &lt;xs:element type="ns:Descriptions" name="Descriptions"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BagAllowanceDescType extends AssociatedObjectBaseType implements
    Serializable
{
    private String applicableParty;
    private String applicableBag;
    private Descriptions descriptions;

    /** 
     * Get the 'ApplicableParty' element value. Baggage weight restriction application.  Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicableParty() {
        return applicableParty;
    }

    /** 
     * Set the 'ApplicableParty' element value. Baggage weight restriction application.  Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @param applicableParty
     */
    public void setApplicableParty(String applicableParty) {
        this.applicableParty = applicableParty;
    }

    /** 
     * Get the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBag() {
        return applicableBag;
    }

    /** 
     * Set the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBag
     */
    public void setApplicableBag(String applicableBag) {
        this.applicableBag = applicableBag;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }
}
