
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A BAGGAGE OFFER with additional Significant Carrier, Baggage Characteristics (e.g. dimensions/ weight) and Disclosures.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageItemType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Price" minOccurs="0">
 *           &lt;!-- Reference to inner class Price -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
 *         &lt;xs:element name="BagDetails" minOccurs="0">
 *           &lt;!-- Reference to inner class BagDetails -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageItemType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Price price;
    private String validatingCarrier;
    private BagDetails bagDetails;

    /** 
     * Get the 'Price' element value.
     * 
     * @return value
     */
    public Price getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value.
     * 
     * @param price
     */
    public void setPrice(Price price) {
        this.price = price;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'BagDetails' element value.
     * 
     * @return value
     */
    public BagDetails getBagDetails() {
        return bagDetails;
    }

    /** 
     * Set the 'BagDetails' element value.
     * 
     * @param bagDetails
     */
    public void setBagDetails(BagDetails bagDetails) {
        this.bagDetails = bagDetails;
    }
    /** 
     * Price.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Price implements Serializable
    {
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private CombinationPriceType combinationPricing;
        private AwardPriceUnitType awardPricing;

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            this.awardPricing = awardPricing;
        }
    }
    /** 
     * Baggage Details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BagDetail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class BagDetail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagDetails implements Serializable
    {
        private List<BagDetail> bagDetailList = new ArrayList<BagDetail>();

        /** 
         * Get the list of 'BagDetail' element items.
         * 
         * @return list
         */
        public List<BagDetail> getBagDetailList() {
            return bagDetailList;
        }

        /** 
         * Set the list of 'BagDetail' element items.
         * 
         * @param list
         */
        public void setBagDetailList(List<BagDetail> list) {
            bagDetailList = list;
        }
        /** 
         * Baggage detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDetail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ValidatingCarrier"/>
         *       &lt;xs:element ref="ns:CheckedBags" minOccurs="0"/>
         *       &lt;xs:element ref="ns:CarryOnBags" minOccurs="0"/>
         *       &lt;xs:element type="ns:BagDisclosureType" name="Disclosure" minOccurs="0"/>
         *       &lt;xs:element name="Price" minOccurs="0">
         *         &lt;!-- Reference to inner class Price -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:BagDetailAssociation" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BagDetail implements Serializable
        {
            private String validatingCarrier;
            private CheckedBagAllowanceType checkedBags;
            private CarryOnAllowanceType carryOnBags;
            private BagDisclosureType disclosure;
            private Price price;
            private BagDetailAssociation bagDetailAssociation;

            /** 
             * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
            A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
             * 
             * @return value
             */
            public String getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
            A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(String validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'CheckedBags' element value.
             * 
             * @return value
             */
            public CheckedBagAllowanceType getCheckedBags() {
                return checkedBags;
            }

            /** 
             * Set the 'CheckedBags' element value.
             * 
             * @param checkedBags
             */
            public void setCheckedBags(CheckedBagAllowanceType checkedBags) {
                this.checkedBags = checkedBags;
            }

            /** 
             * Get the 'CarryOnBags' element value.
             * 
             * @return value
             */
            public CarryOnAllowanceType getCarryOnBags() {
                return carryOnBags;
            }

            /** 
             * Set the 'CarryOnBags' element value.
             * 
             * @param carryOnBags
             */
            public void setCarryOnBags(CarryOnAllowanceType carryOnBags) {
                this.carryOnBags = carryOnBags;
            }

            /** 
             * Get the 'Disclosure' element value. Baggage Disclosure information.
             * 
             * @return value
             */
            public BagDisclosureType getDisclosure() {
                return disclosure;
            }

            /** 
             * Set the 'Disclosure' element value. Baggage Disclosure information.
             * 
             * @param disclosure
             */
            public void setDisclosure(BagDisclosureType disclosure) {
                this.disclosure = disclosure;
            }

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public Price getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(Price price) {
                this.price = price;
            }

            /** 
             * Get the 'BagDetailAssociation' element value.
             * 
             * @return value
             */
            public BagDetailAssociation getBagDetailAssociation() {
                return bagDetailAssociation;
            }

            /** 
             * Set the 'BagDetailAssociation' element value.
             * 
             * @param bagDetailAssociation
             */
            public void setBagDetailAssociation(
                    BagDetailAssociation bagDetailAssociation) {
                this.bagDetailAssociation = bagDetailAssociation;
            }
            /** 
             * Elements relating to baggage charges.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:AwardPricing"/>
             *       &lt;xs:element ref="ns:CombinationPricing"/>
             *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
             *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
             *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Price implements Serializable
            {
                private int priceSelect = -1;
                private static final int AWARD_PRICING_CHOICE = 0;
                private static final int COMBINATION_PRICING_CHOICE = 1;
                private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 2;
                private static final int DETAIL_CURRENCY_PRICE_CHOICE = 3;
                private static final int ENCODED_CURRENCY_PRICE_CHOICE = 4;
                private AwardPriceUnitType awardPricing;
                private CombinationPriceType combinationPricing;
                private SimpleCurrencyPrice simpleCurrencyPrice;
                private DetailCurrencyPriceType detailCurrencyPrice;
                private EncodedCurrencyPrice encodedCurrencyPrice;

                private void setPriceSelect(int choice) {
                    if (priceSelect == -1) {
                        priceSelect = choice;
                    } else if (priceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPriceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPriceSelect() {
                    priceSelect = -1;
                }

                /** 
                 * Check if AwardPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAwardPricing() {
                    return priceSelect == AWARD_PRICING_CHOICE;
                }

                /** 
                 * Get the 'AwardPricing' element value.
                 * 
                 * @return value
                 */
                public AwardPriceUnitType getAwardPricing() {
                    return awardPricing;
                }

                /** 
                 * Set the 'AwardPricing' element value.
                 * 
                 * @param awardPricing
                 */
                public void setAwardPricing(AwardPriceUnitType awardPricing) {
                    setPriceSelect(AWARD_PRICING_CHOICE);
                    this.awardPricing = awardPricing;
                }

                /** 
                 * Check if CombinationPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCombinationPricing() {
                    return priceSelect == COMBINATION_PRICING_CHOICE;
                }

                /** 
                 * Get the 'CombinationPricing' element value.
                 * 
                 * @return value
                 */
                public CombinationPriceType getCombinationPricing() {
                    return combinationPricing;
                }

                /** 
                 * Set the 'CombinationPricing' element value.
                 * 
                 * @param combinationPricing
                 */
                public void setCombinationPricing(
                        CombinationPriceType combinationPricing) {
                    setPriceSelect(COMBINATION_PRICING_CHOICE);
                    this.combinationPricing = combinationPricing;
                }

                /** 
                 * Check if SimpleCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSimpleCurrencyPrice() {
                    return priceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'SimpleCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public SimpleCurrencyPrice getSimpleCurrencyPrice() {
                    return simpleCurrencyPrice;
                }

                /** 
                 * Set the 'SimpleCurrencyPrice' element value.
                 * 
                 * @param simpleCurrencyPrice
                 */
                public void setSimpleCurrencyPrice(
                        SimpleCurrencyPrice simpleCurrencyPrice) {
                    setPriceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                    this.simpleCurrencyPrice = simpleCurrencyPrice;
                }

                /** 
                 * Check if DetailCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifDetailCurrencyPrice() {
                    return priceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'DetailCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public DetailCurrencyPriceType getDetailCurrencyPrice() {
                    return detailCurrencyPrice;
                }

                /** 
                 * Set the 'DetailCurrencyPrice' element value.
                 * 
                 * @param detailCurrencyPrice
                 */
                public void setDetailCurrencyPrice(
                        DetailCurrencyPriceType detailCurrencyPrice) {
                    setPriceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                    this.detailCurrencyPrice = detailCurrencyPrice;
                }

                /** 
                 * Check if EncodedCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifEncodedCurrencyPrice() {
                    return priceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'EncodedCurrencyPrice' element value.
                 * 
                 * @return value
                 */
                public EncodedCurrencyPrice getEncodedCurrencyPrice() {
                    return encodedCurrencyPrice;
                }

                /** 
                 * Set the 'EncodedCurrencyPrice' element value.
                 * 
                 * @param encodedCurrencyPrice
                 */
                public void setEncodedCurrencyPrice(
                        EncodedCurrencyPrice encodedCurrencyPrice) {
                    setPriceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                    this.encodedCurrencyPrice = encodedCurrencyPrice;
                }
            }
        }
    }
}
