
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * BAGGAGE PRICING Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggagePricingQualifierType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CodesetType" name="CarryOn" minOccurs="0"/>
 *         &lt;xs:element type="ns:CodesetType" name="PrepaidOption" minOccurs="0"/>
 *         &lt;xs:element type="ns:CodesetType" name="RequestAction" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="OptionalCharges" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggagePricingQualifierType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private CodesetType carryOn;
    private CodesetType prepaidOption;
    private CodesetType requestAction;
    private String optionalCharges;

    /** 
     * Get the 'CarryOn' element value. Carry-on options requested. Example: N (DO NOT PROCESS CARRY-ON RECORDS)

    Encoding Scheme: IATA PADIS code list BCC-Baggage Carry On Action
     * 
     * @return value
     */
    public CodesetType getCarryOn() {
        return carryOn;
    }

    /** 
     * Set the 'CarryOn' element value. Carry-on options requested. Example: N (DO NOT PROCESS CARRY-ON RECORDS)

    Encoding Scheme: IATA PADIS code list BCC-Baggage Carry On Action
     * 
     * @param carryOn
     */
    public void setCarryOn(CodesetType carryOn) {
        this.carryOn = carryOn;
    }

    /** 
     * Get the 'PrepaidOption' element value. Prepaid option. Example: O (ONLY RETURN PREPAID BAG FEE)

    Encoding Scheme: IATA PADIS code list BPO-Baggage Prepaid Option
     * 
     * @return value
     */
    public CodesetType getPrepaidOption() {
        return prepaidOption;
    }

    /** 
     * Set the 'PrepaidOption' element value. Prepaid option. Example: O (ONLY RETURN PREPAID BAG FEE)

    Encoding Scheme: IATA PADIS code list BPO-Baggage Prepaid Option
     * 
     * @param prepaidOption
     */
    public void setPrepaidOption(CodesetType prepaidOption) {
        this.prepaidOption = prepaidOption;
    }

    /** 
     * Get the 'RequestAction' element value. Request action. Example: D (DISPLAY ONLY)

    Encoding Scheme: IATA PADIS Code List for data element 1225
     * 
     * @return value
     */
    public CodesetType getRequestAction() {
        return requestAction;
    }

    /** 
     * Set the 'RequestAction' element value. Request action. Example: D (DISPLAY ONLY)

    Encoding Scheme: IATA PADIS Code List for data element 1225
     * 
     * @param requestAction
     */
    public void setRequestAction(CodesetType requestAction) {
        this.requestAction = requestAction;
    }

    /** 
     * Get the 'OptionalCharges' element value. Allowance catalog requested. Example: C (CATALOG ONLY)
     * 
     * @return value
     */
    public String getOptionalCharges() {
        return optionalCharges;
    }

    /** 
     * Set the 'OptionalCharges' element value. Allowance catalog requested. Example: C (CATALOG ONLY)
     * 
     * @param optionalCharges
     */
    public void setOptionalCharges(String optionalCharges) {
        this.optionalCharges = optionalCharges;
    }
}
