
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Secure Authorization CVC/CVC2, etc. Presence Contentual List. Examples: NotSubmitted, Included, Illegible, NotPresent

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CVC_SubmissionListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Illegible"/>
 *     &lt;xs:enumeration value="Included"/>
 *     &lt;xs:enumeration value="NotPresent"/>
 *     &lt;xs:enumeration value="NotSubmitted"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CVCSubmissionListType implements Serializable {
    /** 
     * Card holder has stated CVC is illegible.
     */
    ILLEGIBLE("Illegible"), /** 
                             * Airline has included CVC in the Auth / Purchase.
                             */
    INCLUDED("Included"), /** 
                           * Card holder has stated CVC is not present.
                           */
    NOT_PRESENT("NotPresent"), /** 
                                * Airline has not submitted CVC.
                                */
    NOT_SUBMITTED("NotSubmitted");
    private final String value;

    private CVCSubmissionListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CVCSubmissionListType convert(String value) {
        for (CVCSubmissionListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
