
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * UTM Search Campaign Referral definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CampaignReferralType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="UTM">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="xs:string" name="ReferrerURL" minOccurs="0"/>
 *               &lt;xs:element type="ns:CampaignUTM_ParameterType" name="Other_UTMs" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Campaign"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Source"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Medium"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Content"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Term"/>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Localization" minOccurs="0">
 *           &lt;!-- Reference to inner class Localization -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CampaignReferralType extends TrxProcessObjectBaseType implements
    Serializable
{
    private String UTMReferrerURL;
    private CampaignUTMParameterType UTMOtherUTMs;
    private String UTMCampaign;
    private String UTMSource;
    private String UTMMedium;
    private String UTMContent;
    private String UTMTerm;
    private Localization localization;

    /** 
     * Get the 'ReferrerURL' element value. 
                        A complete Referrer URL with all UTM parameters included. Example: http://www.farecompare.com/12q/results.html?c2=n#results?quoteKey=CPIECNYC201406300000R201407170000P1CTF
                      
     * 
     * @return value
     */
    public String getUTMReferrerURL() {
        return UTMReferrerURL;
    }

    /** 
     * Set the 'ReferrerURL' element value. 
                        A complete Referrer URL with all UTM parameters included. Example: http://www.farecompare.com/12q/results.html?c2=n#results?quoteKey=CPIECNYC201406300000R201407170000P1CTF
                      
     * 
     * @param UTMReferrerURL
     */
    public void setUTMReferrerURL(String UTMReferrerURL) {
        this.UTMReferrerURL = UTMReferrerURL;
    }

    /** 
     * Get the 'Other_UTMs' element value. 
                        Other (Custom) Campaign Urchin Tracking Method (UTM) Parameter(s).
                      
     * 
     * @return value
     */
    public CampaignUTMParameterType getUTMOtherUTMs() {
        return UTMOtherUTMs;
    }

    /** 
     * Set the 'Other_UTMs' element value. 
                        Other (Custom) Campaign Urchin Tracking Method (UTM) Parameter(s).
                      
     * 
     * @param UTMOtherUTMs
     */
    public void setUTMOtherUTMs(CampaignUTMParameterType UTMOtherUTMs) {
        this.UTMOtherUTMs = UTMOtherUTMs;
    }

    /** 
     * Get the 'Campaign' attribute value. 
                      UTM Campaign Name parameter. Examples: flightofferreferral, utm_campaign=flightofferreferral Note: This identifies and groups all of the content from one campaign.
                    
     * 
     * @return value
     */
    public String getUTMCampaign() {
        return UTMCampaign;
    }

    /** 
     * Set the 'Campaign' attribute value. 
                      UTM Campaign Name parameter. Examples: flightofferreferral, utm_campaign=flightofferreferral Note: This identifies and groups all of the content from one campaign.
                    
     * 
     * @param UTMCampaign
     */
    public void setUTMCampaign(String UTMCampaign) {
        this.UTMCampaign = UTMCampaign;
    }

    /** 
     * Get the 'Source' attribute value. 
                      UTM Referral Source parameter. Examples: priceline, utm_source=priceline Note: This is the website that initiated the referral.
                    
     * 
     * @return value
     */
    public String getUTMSource() {
        return UTMSource;
    }

    /** 
     * Set the 'Source' attribute value. 
                      UTM Referral Source parameter. Examples: priceline, utm_source=priceline Note: This is the website that initiated the referral.
                    
     * 
     * @param UTMSource
     */
    public void setUTMSource(String UTMSource) {
        this.UTMSource = UTMSource;
    }

    /** 
     * Get the 'Medium' attribute value. 
                      UTM Medium parameter. Examples: referral, utm_medium=referral Note: This is used to identify the type of marketing medium that the link is featured in.
                    
     * 
     * @return value
     */
    public String getUTMMedium() {
        return UTMMedium;
    }

    /** 
     * Set the 'Medium' attribute value. 
                      UTM Medium parameter. Examples: referral, utm_medium=referral Note: This is used to identify the type of marketing medium that the link is featured in.
                    
     * 
     * @param UTMMedium
     */
    public void setUTMMedium(String UTMMedium) {
        this.UTMMedium = UTMMedium;
    }

    /** 
     * Get the 'Content' attribute value. 
                      UTM Content parameter. Examples: sidebarlink, utm_content=sidebarlink Note: This is used to track the different types of content that point to the same URL from the same campaign, source and medium codes. Often used in PPC or with two identical links on the same page.
                    
     * 
     * @return value
     */
    public String getUTMContent() {
        return UTMContent;
    }

    /** 
     * Set the 'Content' attribute value. 
                      UTM Content parameter. Examples: sidebarlink, utm_content=sidebarlink Note: This is used to track the different types of content that point to the same URL from the same campaign, source and medium codes. Often used in PPC or with two identical links on the same page.
                    
     * 
     * @param UTMContent
     */
    public void setUTMContent(String UTMContent) {
        this.UTMContent = UTMContent;
    }

    /** 
     * Get the 'Term' attribute value. 
                      UTM Term parameter. Examples: flight+offer, utm_term=flight+offer Note: This is used to identify the keywords associated with the campaign.
                    
     * 
     * @return value
     */
    public String getUTMTerm() {
        return UTMTerm;
    }

    /** 
     * Set the 'Term' attribute value. 
                      UTM Term parameter. Examples: flight+offer, utm_term=flight+offer Note: This is used to identify the keywords associated with the campaign.
                    
     * 
     * @param UTMTerm
     */
    public void setUTMTerm(String UTMTerm) {
        this.UTMTerm = UTMTerm;
    }

    /** 
     * Get the 'Localization' element value.
     * 
     * @return value
     */
    public Localization getLocalization() {
        return localization;
    }

    /** 
     * Set the 'Localization' element value.
     * 
     * @param localization
     */
    public void setLocalization(Localization localization) {
        this.localization = localization;
    }
    /** 
     * Referrer-specified localization (i18n) parameters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Localization" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="LanguageCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Localization implements Serializable
    {
        private String countryCode;
        private String currencyCode;
        private String languageCode;

        /** 
         * Get the 'CountryCode' attribute value. 
                        Referrer Market Country Code. Examples: US, FR Encoding Scheme: ISO 3166-1 (two character) Country Code Note: This country code may be specified if it differs from point of sale country code.
                      
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' attribute value. 
                        Referrer Market Country Code. Examples: US, FR Encoding Scheme: ISO 3166-1 (two character) Country Code Note: This country code may be specified if it differs from point of sale country code.
                      
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. 
                        Referrer Local Currency Code. Example: USD Encoding Scheme: ISO 4217 (three alpha character) Currency Code Note: This currency code may be specified if it differs from point of sale currency code.
                      
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. 
                        Referrer Local Currency Code. Example: USD Encoding Scheme: ISO 4217 (three alpha character) Currency Code Note: This currency code may be specified if it differs from point of sale currency code.
                      
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'LanguageCode' attribute value. 
                        Referrer Local Language Code. Example: en-US Encoding Scheme: Microsoft National Language Support (NLS) Code
                      
         * 
         * @return value
         */
        public String getLanguageCode() {
            return languageCode;
        }

        /** 
         * Set the 'LanguageCode' attribute value. 
                        Referrer Local Language Code. Example: en-US Encoding Scheme: Microsoft National Language Support (NLS) Code
                      
         * 
         * @param languageCode
         */
        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }
    }
}
