
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * CARRIER FEE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierFeeInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:PaymentForm" minOccurs="0"/>
 *     &lt;xs:element name="CarrierFees" minOccurs="0">
 *       &lt;!-- Reference to inner class CarrierFees -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierFeeInfoType implements Serializable
{
    private AcceptedPaymentFormType paymentForm;
    private CarrierFees carrierFees;
    private TaxDetailType taxes;

    /** 
     * Get the 'PaymentForm' element value.
     * 
     * @return value
     */
    public AcceptedPaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value.
     * 
     * @param paymentForm
     */
    public void setPaymentForm(AcceptedPaymentFormType paymentForm) {
        this.paymentForm = paymentForm;
    }

    /** 
     * Get the 'CarrierFees' element value.
     * 
     * @return value
     */
    public CarrierFees getCarrierFees() {
        return carrierFees;
    }

    /** 
     * Set the 'CarrierFees' element value.
     * 
     * @param carrierFees
     */
    public void setCarrierFees(CarrierFees carrierFees) {
        this.carrierFees = carrierFees;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }
    /** 
     * Carrier Fee detail information to include Type, FeeAmount, FareComponent, ClassCode and Reporting code for Pricing Method.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierFees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Fee" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Fee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CarrierFees implements Serializable
    {
        private List<Fee> feeList = new ArrayList<Fee>();

        /** 
         * Get the list of 'Fee' element items.
         * 
         * @return list
         */
        public List<Fee> getFeeList() {
            return feeList;
        }

        /** 
         * Set the list of 'Fee' element items.
         * 
         * @param list
         */
        public void setFeeList(List<Fee> list) {
            feeList = list;
        }
        /** 
         * Carrier Fee detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CodesetType" name="Type"/>
         *       &lt;xs:element name="FeeAmount" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class FeeAmount -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
         *       &lt;xs:element ref="ns:PaymentForm" minOccurs="0"/>
         *       &lt;xs:element name="FareComponent" minOccurs="0">
         *         &lt;!-- Reference to inner class FareComponent -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AirlineID" minOccurs="0">
         *         &lt;!-- Reference to inner class AirlineID -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareClassCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ReportingCode" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Fee implements Serializable
        {
            private CodesetType type;
            private List<FeeAmount> feeAmountList = new ArrayList<FeeAmount>();
            private TaxDetailType taxes;
            private AcceptedPaymentFormType paymentForm;
            private FareComponent fareComponent;
            private AirlineID airlineID;
            private String fareClassCode;
            private String reportingCode;

            /** 
             * Get the 'Type' element value. Carrier Fee Type.
            Encoding Scheme: IATA Padis Codeset - List for data element 9750 (Option)

            Note: This is the type of the carrier fee related to a booking or ticketing or service.
             * 
             * @return value
             */
            public CodesetType getType() {
                return type;
            }

            /** 
             * Set the 'Type' element value. Carrier Fee Type.
            Encoding Scheme: IATA Padis Codeset - List for data element 9750 (Option)

            Note: This is the type of the carrier fee related to a booking or ticketing or service.
             * 
             * @param type
             */
            public void setType(CodesetType type) {
                this.type = type;
            }

            /** 
             * Get the list of 'FeeAmount' element items.
             * 
             * @return list
             */
            public List<FeeAmount> getFeeAmountList() {
                return feeAmountList;
            }

            /** 
             * Set the list of 'FeeAmount' element items.
             * 
             * @param list
             */
            public void setFeeAmountList(List<FeeAmount> list) {
                feeAmountList = list;
            }

            /** 
             * Get the 'Taxes' element value. A series of data elements representing data required to collect non-airport/government fees, store the fee data, 
            and track the revenue separate from the ticket revenue without requiring a secondary document be issued.
             * 
             * @return value
             */
            public TaxDetailType getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value. A series of data elements representing data required to collect non-airport/government fees, store the fee data, 
            and track the revenue separate from the ticket revenue without requiring a secondary document be issued.
             * 
             * @param taxes
             */
            public void setTaxes(TaxDetailType taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the 'PaymentForm' element value.
             * 
             * @return value
             */
            public AcceptedPaymentFormType getPaymentForm() {
                return paymentForm;
            }

            /** 
             * Set the 'PaymentForm' element value.
             * 
             * @param paymentForm
             */
            public void setPaymentForm(AcceptedPaymentFormType paymentForm) {
                this.paymentForm = paymentForm;
            }

            /** 
             * Get the 'FareComponent' element value.
             * 
             * @return value
             */
            public FareComponent getFareComponent() {
                return fareComponent;
            }

            /** 
             * Set the 'FareComponent' element value.
             * 
             * @param fareComponent
             */
            public void setFareComponent(FareComponent fareComponent) {
                this.fareComponent = fareComponent;
            }

            /** 
             * Get the 'AirlineID' element value.
             * 
             * @return value
             */
            public AirlineID getAirlineID() {
                return airlineID;
            }

            /** 
             * Set the 'AirlineID' element value.
             * 
             * @param airlineID
             */
            public void setAirlineID(AirlineID airlineID) {
                this.airlineID = airlineID;
            }

            /** 
             * Get the 'FareClassCode' element value. Fare class code. Example: M

            Note: This is the fare class code that must be used when matching alternate cateory data as specifed by the carrier fee fare rule code, carrier fee rule number, and carrier fee tariff number fields.
             * 
             * @return value
             */
            public String getFareClassCode() {
                return fareClassCode;
            }

            /** 
             * Set the 'FareClassCode' element value. Fare class code. Example: M

            Note: This is the fare class code that must be used when matching alternate cateory data as specifed by the carrier fee fare rule code, carrier fee rule number, and carrier fee tariff number fields.
             * 
             * @param fareClassCode
             */
            public void setFareClassCode(String fareClassCode) {
                this.fareClassCode = fareClassCode;
            }

            /** 
             * Get the 'ReportingCode' element value. Carrier fee pricing method. Example: A
             * 
             * @return value
             */
            public String getReportingCode() {
                return reportingCode;
            }

            /** 
             * Set the 'ReportingCode' element value. Carrier fee pricing method. Example: A
             * 
             * @param reportingCode
             */
            public void setReportingCode(String reportingCode) {
                this.reportingCode = reportingCode;
            }
            /** 
             * Carrier Fee amount and detail, including fee type, fee application and associated origin/ destination.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeAmount" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Type"/>
             *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
             *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="ns:CodesetType" name="ApplicationCode"/>
             *       &lt;xs:element ref="ns:DepartureCode"/>
             *       &lt;xs:element ref="ns:ArrivalCode"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FeeAmount implements Serializable
            {
                private String type;
                private CurrencyAmountOptType amount;
                private String currencyCode;
                private CodesetType applicationCode;
                private DepartureCode departureCode;
                private ArrivalCode arrivalCode;

                /** 
                 * Get the 'Type' element value. Carrier fee code type.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' element value. Carrier fee code type.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Amount' element value. Carrier fee amount. Example: 100 USD
                 * 
                 * @return value
                 */
                public CurrencyAmountOptType getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Carrier fee amount. Example: 100 USD
                 * 
                 * @param amount
                 */
                public void setAmount(CurrencyAmountOptType amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' element value. Currency encoding for the Carrier Fee Amount. Example: USD
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value. Currency encoding for the Carrier Fee Amount. Example: USD
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'ApplicationCode' element value. Application code. Example: 15 (Not commissionable)

                Encoding Scheme: IATA Padis Codeset - List for data element 9988 (Data Indicator)

                Note: This is used to specify if the fee is not interlineable, not refundable, commissionable or not commissionable.
                 * 
                 * @return value
                 */
                public CodesetType getApplicationCode() {
                    return applicationCode;
                }

                /** 
                 * Set the 'ApplicationCode' element value. Application code. Example: 15 (Not commissionable)

                Encoding Scheme: IATA Padis Codeset - List for data element 9988 (Data Indicator)

                Note: This is used to specify if the fee is not interlineable, not refundable, commissionable or not commissionable.
                 * 
                 * @param applicationCode
                 */
                public void setApplicationCode(CodesetType applicationCode) {
                    this.applicationCode = applicationCode;
                }

                /** 
                 * Get the 'DepartureCode' element value. Departure Airport Location code. Example: TPA

                Encoding Scheme: IATA/ A4A (three character) Airport or City Code
                 * 
                 * @return value
                 */
                public DepartureCode getDepartureCode() {
                    return departureCode;
                }

                /** 
                 * Set the 'DepartureCode' element value. Departure Airport Location code. Example: TPA

                Encoding Scheme: IATA/ A4A (three character) Airport or City Code
                 * 
                 * @param departureCode
                 */
                public void setDepartureCode(DepartureCode departureCode) {
                    this.departureCode = departureCode;
                }

                /** 
                 * Get the 'ArrivalCode' element value.
                 * 
                 * @return value
                 */
                public ArrivalCode getArrivalCode() {
                    return arrivalCode;
                }

                /** 
                 * Set the 'ArrivalCode' element value.
                 * 
                 * @param arrivalCode
                 */
                public void setArrivalCode(ArrivalCode arrivalCode) {
                    this.arrivalCode = arrivalCode;
                }
            }
            /** 
             * Fare Component information as may be applicable in filed fares scenarios.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:integer" name="Number" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TariffNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="RuleNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="RuleCode" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareComponent implements Serializable
            {
                private BigInteger number;
                private String tariffNumber;
                private String ruleNumber;
                private String ruleCode;

                /** 
                 * Get the 'Number' element value. Fare Component calculation order (sequence number.) Example: 001
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' element value. Fare Component calculation order (sequence number.) Example: 001
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }

                /** 
                 * Get the 'TariffNumber' element value. Tariff number for where the fare data is filed. Example: 9171
                 * 
                 * @return value
                 */
                public String getTariffNumber() {
                    return tariffNumber;
                }

                /** 
                 * Set the 'TariffNumber' element value. Tariff number for where the fare data is filed. Example: 9171
                 * 
                 * @param tariffNumber
                 */
                public void setTariffNumber(String tariffNumber) {
                    this.tariffNumber = tariffNumber;
                }

                /** 
                 * Get the 'RuleNumber' element value. Rule number. Example: 126

                Note: This is the rule number within the tariff where the fare data is filed.
                 * 
                 * @return value
                 */
                public String getRuleNumber() {
                    return ruleNumber;
                }

                /** 
                 * Set the 'RuleNumber' element value. Rule number. Example: 126

                Note: This is the rule number within the tariff where the fare data is filed.
                 * 
                 * @param ruleNumber
                 */
                public void setRuleNumber(String ruleNumber) {
                    this.ruleNumber = ruleNumber;
                }

                /** 
                 * Get the 'RuleCode' element value. Rule Code. Example: 12BE

                Note: This is a system generated code indicating that the ticketed fare is from a specific rule filed fare sent by the issuing system.
                 * 
                 * @return value
                 */
                public String getRuleCode() {
                    return ruleCode;
                }

                /** 
                 * Set the 'RuleCode' element value. Rule Code. Example: 12BE

                Note: This is a system generated code indicating that the ticketed fare is from a specific rule filed fare sent by the issuing system.
                 * 
                 * @param ruleCode
                 */
                public void setRuleCode(String ruleCode) {
                    this.ruleCode = ruleCode;
                }
            }
            /** 
             * A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:AirlineID_Type">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirlineID extends AirlineIDType implements
                Serializable
            {
                private String name;

                /** 
                 * Get the 'Name' attribute value. Carrier Fee Commercial Name. Example: British Airways
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. Carrier Fee Commercial Name. Example: British Airways
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }
}
