
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Currency Code Application constrained list.

 Examples: Actual, Display, Requested, Conversion, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Billing"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Home"/>
 *     &lt;xs:enumeration value="ServiceLocation"/>
 *     &lt;xs:enumeration value="StayLocation"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ContactListType implements Serializable {
    BILLING("Billing"), BUSINESS("Business"), HOME("Home"), SERVICE_LOCATION(
            "ServiceLocation"), STAY_LOCATION("StayLocation");
    private final String value;

    private ContactListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ContactListType convert(String value) {
        for (ContactListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
