
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.Date;

/** 
 * A data type definition for Commonly Used Effective (start) and Expiration (end) Period.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorePeriodGrpType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DatePeriodType" name="Date" minOccurs="0"/>
 *     &lt;xs:element type="ns:DateTimePeriodType" name="DateTime" minOccurs="0"/>
 *     &lt;xs:element name="TimeStamp" minOccurs="0">
 *       &lt;!-- Reference to inner class TimeStamp -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CorePeriodGrpType implements Serializable
{
    private DatePeriodType date;
    private DateTimePeriodType dateTime;
    private TimeStamp timeStamp;

    /** 
     * Get the 'Date' element value. Effective (start) and expiration (end) Dates.
     * 
     * @return value
     */
    public DatePeriodType getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Effective (start) and expiration (end) Dates.
     * 
     * @param date
     */
    public void setDate(DatePeriodType date) {
        this.date = date;
    }

    /** 
     * Get the 'DateTime' element value. Effective (start) and expiration (end) Date and Time.
     * 
     * @return value
     */
    public DateTimePeriodType getDateTime() {
        return dateTime;
    }

    /** 
     * Set the 'DateTime' element value. Effective (start) and expiration (end) Date and Time.
     * 
     * @param dateTime
     */
    public void setDateTime(DateTimePeriodType dateTime) {
        this.dateTime = dateTime;
    }

    /** 
     * Get the 'TimeStamp' element value.
     * 
     * @return value
     */
    public TimeStamp getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' element value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(TimeStamp timeStamp) {
        this.timeStamp = timeStamp;
    }
    /** 
     * Effective (start) and expiration (end) Timestamp.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeStamp" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="Effective"/>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="Expiration"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TimeStamp implements Serializable
    {
        private Date effective;
        private Date expiration;

        /** 
         * Get the 'Effective' attribute value. Effective (start) Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public Date getEffective() {
            return effective;
        }

        /** 
         * Set the 'Effective' attribute value. Effective (start) Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @param effective
         */
        public void setEffective(Date effective) {
            this.effective = effective;
        }

        /** 
         * Get the 'Expiration' attribute value. Expiration (end) Timestamp. Example: 2017-11-13T13:00:00Z
         * 
         * @return value
         */
        public Date getExpiration() {
            return expiration;
        }

        /** 
         * Set the 'Expiration' attribute value. Expiration (end) Timestamp. Example: 2017-11-13T13:00:00Z
         * 
         * @param expiration
         */
        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }
    }
}
