
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * COUPON EFFECTIVE PERIOD definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponEffectiveType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="EffectiveDatePeriod" minOccurs="0">
 *           &lt;!-- Reference to inner class EffectiveDatePeriod -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="EffectiveDateTimePeriod" minOccurs="0">
 *           &lt;!-- Reference to inner class EffectiveDateTimePeriod -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponEffectiveType extends AssociatedObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int EFFECTIVE_DATE_PERIOD_CHOICE = 0;
    private static final int EFFECTIVE_DATE_TIME_PERIOD_CHOICE = 1;
    private EffectiveDatePeriod effectiveDatePeriod;
    private EffectiveDateTimePeriod effectiveDateTimePeriod;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if EffectiveDatePeriod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEffectiveDatePeriod() {
        return choiceSelect == EFFECTIVE_DATE_PERIOD_CHOICE;
    }

    /** 
     * Get the 'EffectiveDatePeriod' element value.
     * 
     * @return value
     */
    public EffectiveDatePeriod getEffectiveDatePeriod() {
        return effectiveDatePeriod;
    }

    /** 
     * Set the 'EffectiveDatePeriod' element value.
     * 
     * @param effectiveDatePeriod
     */
    public void setEffectiveDatePeriod(EffectiveDatePeriod effectiveDatePeriod) {
        setChoiceSelect(EFFECTIVE_DATE_PERIOD_CHOICE);
        this.effectiveDatePeriod = effectiveDatePeriod;
    }

    /** 
     * Check if EffectiveDateTimePeriod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEffectiveDateTimePeriod() {
        return choiceSelect == EFFECTIVE_DATE_TIME_PERIOD_CHOICE;
    }

    /** 
     * Get the 'EffectiveDateTimePeriod' element value.
     * 
     * @return value
     */
    public EffectiveDateTimePeriod getEffectiveDateTimePeriod() {
        return effectiveDateTimePeriod;
    }

    /** 
     * Set the 'EffectiveDateTimePeriod' element value.
     * 
     * @param effectiveDateTimePeriod
     */
    public void setEffectiveDateTimePeriod(
            EffectiveDateTimePeriod effectiveDateTimePeriod) {
        setChoiceSelect(EFFECTIVE_DATE_TIME_PERIOD_CHOICE);
        this.effectiveDateTimePeriod = effectiveDateTimePeriod;
    }
    /** 
     * The period in which the applicable coupon on an accountable document may be used for travel or for obtaining a service it entitles the holder to.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveDatePeriod" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DatePeriodRepType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectiveDatePeriod extends DatePeriodRepType implements
        Serializable
    {
        private String duration;

        /** 
         * Get the 'Duration' element value. Effective period duration. Example: P3M

        Note: This maybe used in combination with the Effective date, versus specifying an Expiration date.
         * 
         * @return value
         */
        public String getDuration() {
            return duration;
        }

        /** 
         * Set the 'Duration' element value. Effective period duration. Example: P3M

        Note: This maybe used in combination with the Effective date, versus specifying an Expiration date.
         * 
         * @param duration
         */
        public void setDuration(String duration) {
            this.duration = duration;
        }
    }
    /** 
     * The period in which the applicable coupon on an accountable document may be used for travel or for obtaining a service it entitles the holder to.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveDateTimePeriod" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DateTimePeriodRepType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectiveDateTimePeriod extends DateTimePeriodRepType
        implements Serializable
    {
        private String duration;

        /** 
         * Get the 'Duration' element value. Effective period duration. Example: P3M

        Note: This maybe used in combination with the Effective date, versus specifying an Expiration date.
         * 
         * @return value
         */
        public String getDuration() {
            return duration;
        }

        /** 
         * Set the 'Duration' element value. Effective period duration. Example: P3M

        Note: This maybe used in combination with the Effective date, versus specifying an Expiration date.
         * 
         * @param duration
         */
        public void setDuration(String duration) {
            this.duration = duration;
        }
    }
}
