
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * COUPON definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="CouponItinSequenceNbr" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="CouponNumber"/>
 *     &lt;xs:element type="xs:string" name="CouponReference" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CouponMedia" minOccurs="0"/>
 *     &lt;xs:element type="ns:CouponEffectiveType" name="CouponValid" minOccurs="0"/>
 *     &lt;xs:element type="ns:CodesetType" name="Status"/>
 *     &lt;xs:element type="ns:CodesetType" name="InvoluntaryIndicatorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SettlementAuthCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AssocFareBasis" minOccurs="0"/>
 *     &lt;xs:element type="ns:PromotionType" name="PromoCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DateOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="ServiceQuantity" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ServiceReferences" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Value" minOccurs="0"/>
 *     &lt;xs:element type="ns:CouponSoldAirlineType" name="SoldAirlineInfo" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element ref="ns:InConnectionWithInfo" minOccurs="0"/>
 *     &lt;xs:element name="PresentInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class PresentInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ReasonForIssuance" minOccurs="0">
 *       &lt;!-- Reference to inner class ReasonForIssuance -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FiledFeeInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class FiledFeeInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ProductCharacteristic" minOccurs="0">
 *       &lt;!-- Reference to inner class ProductCharacteristic -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AdditionalServicesInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class AdditionalServicesInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ExcessBaggage" minOccurs="0">
 *       &lt;!-- Reference to inner class ExcessBaggage -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ValidatingAirline" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Remark" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddlBaggageInfoType" name="AddlBaggageInfo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResAirlineDesig" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="ResDateOfFlight" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResDesigAirportCityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResFlightDepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResOriginAirportCityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResBookDesign" minOccurs="0"/>
 *     &lt;xs:element type="ns:CodesetType" name="ResStatusCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ConsumedAtIssuanceInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponInfoType implements Serializable
{
    private BigInteger couponItinSequenceNbr;
    private BigInteger couponNumber;
    private String couponReference;
    private FareBasisCodeType fareBasisCode;
    private String couponMedia;
    private CouponEffectiveType couponValid;
    private CodesetType status;
    private CodesetType involuntaryIndicatorCode;
    private String settlementAuthCode;
    private String assocFareBasis;
    private PromotionType promoCode;
    private Date dateOfService;
    private BigInteger serviceQuantity;
    private ServiceReferences serviceReferences;
    private CurrencyAmountOptType value;
    private CouponSoldAirlineType soldAirlineInfo;
    private Choice choice;
    private InConnectionWithType inConnectionWithInfo;
    private PresentInfo presentInfo;
    private ReasonForIssuance reasonForIssuance;
    private FiledFeeInfo filedFeeInfo;
    private ProductCharacteristic productCharacteristic;
    private AdditionalServicesInfo additionalServicesInfo;
    private ExcessBaggage excessBaggage;
    private String validatingAirline;
    private String remark;
    private AddlBaggageInfoType addlBaggageInfo;
    private String resAirlineDesig;
    private Date resDateOfFlight;
    private String resDesigAirportCityCode;
    private String resFlightDepartureTime;
    private String resFlightNumber;
    private String resOriginAirportCityCode;
    private String resBookDesign;
    private CodesetType resStatusCode;
    private Boolean consumedAtIssuanceInd;

    /** 
     * Get the 'CouponItinSequenceNbr' element value. Coupon Sequence Number. Example: 2

    Note: This is the number representing the order in which this coupon was used or is to be used.
     * 
     * @return value
     */
    public BigInteger getCouponItinSequenceNbr() {
        return couponItinSequenceNbr;
    }

    /** 
     * Set the 'CouponItinSequenceNbr' element value. Coupon Sequence Number. Example: 2

    Note: This is the number representing the order in which this coupon was used or is to be used.
     * 
     * @param couponItinSequenceNbr
     */
    public void setCouponItinSequenceNbr(BigInteger couponItinSequenceNbr) {
        this.couponItinSequenceNbr = couponItinSequenceNbr;
    }

    /** 
     * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
     * 
     * @return value
     */
    public BigInteger getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
     * 
     * @param couponNumber
     */
    public void setCouponNumber(BigInteger couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'CouponReference' element value. Coupon Refence Number. Example: 1

    Note: This is the sequential number (segment identifier) of an individual flight segment.
     * 
     * @return value
     */
    public String getCouponReference() {
        return couponReference;
    }

    /** 
     * Set the 'CouponReference' element value. Coupon Refence Number. Example: 1

    Note: This is the sequential number (segment identifier) of an individual flight segment.
     * 
     * @param couponReference
     */
    public void setCouponReference(String couponReference) {
        this.couponReference = couponReference;
    }

    /** 
     * Get the 'FareBasisCode' element value.
     * 
     * @return value
     */
    public FareBasisCodeType getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'CouponMedia' element value. Coupon Media Type. Examples: Electronc, Paper, Other
     * 
     * @return value
     */
    public String getCouponMedia() {
        return couponMedia;
    }

    /** 
     * Set the 'CouponMedia' element value. Coupon Media Type. Examples: Electronc, Paper, Other
     * 
     * @param couponMedia
     */
    public void setCouponMedia(String couponMedia) {
        this.couponMedia = couponMedia;
    }

    /** 
     * Get the 'CouponValid' element value. Coupon Valid date or date/time period.
     * 
     * @return value
     */
    public CouponEffectiveType getCouponValid() {
        return couponValid;
    }

    /** 
     * Set the 'CouponValid' element value. Coupon Valid date or date/time period.
     * 
     * @param couponValid
     */
    public void setCouponValid(CouponEffectiveType couponValid) {
        this.couponValid = couponValid;
    }

    /** 
     * Get the 'Status' element value. Current status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @return value
     */
    public CodesetType getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Current status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @param status
     */
    public void setStatus(CodesetType status) {
        this.status = status;
    }

    /** 
     * Get the 'InvoluntaryIndicatorCode' element value. Involuntary Change Transaction Code. Example: I (Involuntary - no reason given)

    Encoding Scheme: IATA Padis Codeset - List for data element 1245 (Status indicator, coded)
     * 
     * @return value
     */
    public CodesetType getInvoluntaryIndicatorCode() {
        return involuntaryIndicatorCode;
    }

    /** 
     * Set the 'InvoluntaryIndicatorCode' element value. Involuntary Change Transaction Code. Example: I (Involuntary - no reason given)

    Encoding Scheme: IATA Padis Codeset - List for data element 1245 (Status indicator, coded)
     * 
     * @param involuntaryIndicatorCode
     */
    public void setInvoluntaryIndicatorCode(CodesetType involuntaryIndicatorCode) {
        this.involuntaryIndicatorCode = involuntaryIndicatorCode;
    }

    /** 
     * Get the 'SettlementAuthCode' element value. Settlement Authorization Code. Example: AUTH123

    Note: This is a reference number generated by the validating carrier authorising settlement of a coupon.
     * 
     * @return value
     */
    public String getSettlementAuthCode() {
        return settlementAuthCode;
    }

    /** 
     * Set the 'SettlementAuthCode' element value. Settlement Authorization Code. Example: AUTH123

    Note: This is a reference number generated by the validating carrier authorising settlement of a coupon.
     * 
     * @param settlementAuthCode
     */
    public void setSettlementAuthCode(String settlementAuthCode) {
        this.settlementAuthCode = settlementAuthCode;
    }

    /** 
     * Get the 'AssocFareBasis' element value. Associated Fare Basis Code.

    Note: This is the applicable code provided for IATA Resolution 728 (for the associated EMD.)
     * 
     * @return value
     */
    public String getAssocFareBasis() {
        return assocFareBasis;
    }

    /** 
     * Set the 'AssocFareBasis' element value. Associated Fare Basis Code.

    Note: This is the applicable code provided for IATA Resolution 728 (for the associated EMD.)
     * 
     * @param assocFareBasis
     */
    public void setAssocFareBasis(String assocFareBasis) {
        this.assocFareBasis = assocFareBasis;
    }

    /** 
     * Get the 'PromoCode' element value. Promotional code that applies to the fee. Example: PROMO123
     * 
     * @return value
     */
    public PromotionType getPromoCode() {
        return promoCode;
    }

    /** 
     * Set the 'PromoCode' element value. Promotional code that applies to the fee. Example: PROMO123
     * 
     * @param promoCode
     */
    public void setPromoCode(PromotionType promoCode) {
        this.promoCode = promoCode;
    }

    /** 
     * Get the 'DateOfService' element value. Date of Service. Example: 2017-01-17

    Note: This is the scheduled date of service for this coupon of an EMD.
     * 
     * @return value
     */
    public Date getDateOfService() {
        return dateOfService;
    }

    /** 
     * Set the 'DateOfService' element value. Date of Service. Example: 2017-01-17

    Note: This is the scheduled date of service for this coupon of an EMD.
     * 
     * @param dateOfService
     */
    public void setDateOfService(Date dateOfService) {
        this.dateOfService = dateOfService;
    }

    /** 
     * Get the 'ServiceQuantity' element value. Service Quantity. Example: 1

    Note: Thisis the number of services of the same type that are included in an EMD coupon.
     * 
     * @return value
     */
    public BigInteger getServiceQuantity() {
        return serviceQuantity;
    }

    /** 
     * Set the 'ServiceQuantity' element value. Service Quantity. Example: 1

    Note: Thisis the number of services of the same type that are included in an EMD coupon.
     * 
     * @param serviceQuantity
     */
    public void setServiceQuantity(BigInteger serviceQuantity) {
        this.serviceQuantity = serviceQuantity;
    }

    /** 
     * Get the 'ServiceReferences' element value. Association to services paid by the EMD             Association to multiple Optional Service instance(s). Example: srvc1 srvc2  
     * 
     * @return value
     */
    public ServiceReferences getServiceReferences() {
        return serviceReferences;
    }

    /** 
     * Set the 'ServiceReferences' element value. Association to services paid by the EMD             Association to multiple Optional Service instance(s). Example: srvc1 srvc2  
     * 
     * @param serviceReferences
     */
    public void setServiceReferences(ServiceReferences serviceReferences) {
        this.serviceReferences = serviceReferences;
    }

    /** 
     * Get the 'Value' element value. Coupon Value. Example: 100 USD

    Note: This is the value associated to a single coupon of a miscellaneous document.
     * 
     * @return value
     */
    public CurrencyAmountOptType getValue() {
        return value;
    }

    /** 
     * Set the 'Value' element value. Coupon Value. Example: 100 USD

    Note: This is the value associated to a single coupon of a miscellaneous document.
     * 
     * @param value
     */
    public void setValue(CurrencyAmountOptType value) {
        this.value = value;
    }

    /** 
     * Get the 'SoldAirlineInfo' element value. Date and time, flight number, stopover indicator, and status code.
     * 
     * @return value
     */
    public CouponSoldAirlineType getSoldAirlineInfo() {
        return soldAirlineInfo;
    }

    /** 
     * Set the 'SoldAirlineInfo' element value. Date and time, flight number, stopover indicator, and status code.
     * 
     * @param soldAirlineInfo
     */
    public void setSoldAirlineInfo(CouponSoldAirlineType soldAirlineInfo) {
        this.soldAirlineInfo = soldAirlineInfo;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'InConnectionWithInfo' element value. In connection with document number (A document number representing a transaction that is issued in relation to this transaction); and coupon number (the coupon number(s) associated with the 'in connection with' document number.)
     * 
     * @return value
     */
    public InConnectionWithType getInConnectionWithInfo() {
        return inConnectionWithInfo;
    }

    /** 
     * Set the 'InConnectionWithInfo' element value. In connection with document number (A document number representing a transaction that is issued in relation to this transaction); and coupon number (the coupon number(s) associated with the 'in connection with' document number.)
     * 
     * @param inConnectionWithInfo
     */
    public void setInConnectionWithInfo(
            InConnectionWithType inConnectionWithInfo) {
        this.inConnectionWithInfo = inConnectionWithInfo;
    }

    /** 
     * Get the 'PresentInfo' element value.
     * 
     * @return value
     */
    public PresentInfo getPresentInfo() {
        return presentInfo;
    }

    /** 
     * Set the 'PresentInfo' element value.
     * 
     * @param presentInfo
     */
    public void setPresentInfo(PresentInfo presentInfo) {
        this.presentInfo = presentInfo;
    }

    /** 
     * Get the 'ReasonForIssuance' element value.
     * 
     * @return value
     */
    public ReasonForIssuance getReasonForIssuance() {
        return reasonForIssuance;
    }

    /** 
     * Set the 'ReasonForIssuance' element value.
     * 
     * @param reasonForIssuance
     */
    public void setReasonForIssuance(ReasonForIssuance reasonForIssuance) {
        this.reasonForIssuance = reasonForIssuance;
    }

    /** 
     * Get the 'FiledFeeInfo' element value.
     * 
     * @return value
     */
    public FiledFeeInfo getFiledFeeInfo() {
        return filedFeeInfo;
    }

    /** 
     * Set the 'FiledFeeInfo' element value.
     * 
     * @param filedFeeInfo
     */
    public void setFiledFeeInfo(FiledFeeInfo filedFeeInfo) {
        this.filedFeeInfo = filedFeeInfo;
    }

    /** 
     * Get the 'ProductCharacteristic' element value.
     * 
     * @return value
     */
    public ProductCharacteristic getProductCharacteristic() {
        return productCharacteristic;
    }

    /** 
     * Set the 'ProductCharacteristic' element value.
     * 
     * @param productCharacteristic
     */
    public void setProductCharacteristic(
            ProductCharacteristic productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
    }

    /** 
     * Get the 'AdditionalServicesInfo' element value.
     * 
     * @return value
     */
    public AdditionalServicesInfo getAdditionalServicesInfo() {
        return additionalServicesInfo;
    }

    /** 
     * Set the 'AdditionalServicesInfo' element value.
     * 
     * @param additionalServicesInfo
     */
    public void setAdditionalServicesInfo(
            AdditionalServicesInfo additionalServicesInfo) {
        this.additionalServicesInfo = additionalServicesInfo;
    }

    /** 
     * Get the 'ExcessBaggage' element value.
     * 
     * @return value
     */
    public ExcessBaggage getExcessBaggage() {
        return excessBaggage;
    }

    /** 
     * Set the 'ExcessBaggage' element value.
     * 
     * @param excessBaggage
     */
    public void setExcessBaggage(ExcessBaggage excessBaggage) {
        this.excessBaggage = excessBaggage;
    }

    /** 
     * Get the 'ValidatingAirline' element value. Coupon Validating Airline. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public String getValidatingAirline() {
        return validatingAirline;
    }

    /** 
     * Set the 'ValidatingAirline' element value. Coupon Validating Airline. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param validatingAirline
     */
    public void setValidatingAirline(String validatingAirline) {
        this.validatingAirline = validatingAirline;
    }

    /** 
     * Get the 'Remark' element value. Free text to provide further information related to the document and/or the coupon.
     * 
     * @return value
     */
    public String getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. Free text to provide further information related to the document and/or the coupon.
     * 
     * @param remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'AddlBaggageInfo' element value.
     * 
     * @return value
     */
    public AddlBaggageInfoType getAddlBaggageInfo() {
        return addlBaggageInfo;
    }

    /** 
     * Set the 'AddlBaggageInfo' element value.
     * 
     * @param addlBaggageInfo
     */
    public void setAddlBaggageInfo(AddlBaggageInfoType addlBaggageInfo) {
        this.addlBaggageInfo = addlBaggageInfo;
    }

    /** 
     * Get the 'ResAirlineDesig' element value. The two/three character designator identifying the Marketing Carrier designated in the new reservation.
     * 
     * @return value
     */
    public String getResAirlineDesig() {
        return resAirlineDesig;
    }

    /** 
     * Set the 'ResAirlineDesig' element value. The two/three character designator identifying the Marketing Carrier designated in the new reservation.
     * 
     * @param resAirlineDesig
     */
    public void setResAirlineDesig(String resAirlineDesig) {
        this.resAirlineDesig = resAirlineDesig;
    }

    /** 
     * Get the 'ResDateOfFlight' element value. This field contains the scheduled date of departure of the “Reservation Change” flight.
     * 
     * @return value
     */
    public Date getResDateOfFlight() {
        return resDateOfFlight;
    }

    /** 
     * Set the 'ResDateOfFlight' element value. This field contains the scheduled date of departure of the “Reservation Change” flight.
     * 
     * @param resDateOfFlight
     */
    public void setResDateOfFlight(Date resDateOfFlight) {
        this.resDateOfFlight = resDateOfFlight;
    }

    /** 
     * Get the 'ResDesigAirportCityCode' element value. This field contains the destination Airport/City Code of the “Reservation Change” flight.
     * 
     * @return value
     */
    public String getResDesigAirportCityCode() {
        return resDesigAirportCityCode;
    }

    /** 
     * Set the 'ResDesigAirportCityCode' element value. This field contains the destination Airport/City Code of the “Reservation Change” flight.
     * 
     * @param resDesigAirportCityCode
     */
    public void setResDesigAirportCityCode(String resDesigAirportCityCode) {
        this.resDesigAirportCityCode = resDesigAirportCityCode;
    }

    /** 
     * Get the 'ResFlightDepartureTime' element value. This field contains the scheduled departure time of the “Reservation Change” flight.
     * 
     * @return value
     */
    public String getResFlightDepartureTime() {
        return resFlightDepartureTime;
    }

    /** 
     * Set the 'ResFlightDepartureTime' element value. This field contains the scheduled departure time of the “Reservation Change” flight.
     * 
     * @param resFlightDepartureTime
     */
    public void setResFlightDepartureTime(String resFlightDepartureTime) {
        this.resFlightDepartureTime = resFlightDepartureTime;
    }

    /** 
     * Get the 'ResFlightNumber' element value. This field contains the flight number of the “Reservation Change” (Marketing Carrier) flight.
     * 
     * @return value
     */
    public String getResFlightNumber() {
        return resFlightNumber;
    }

    /** 
     * Set the 'ResFlightNumber' element value. This field contains the flight number of the “Reservation Change” (Marketing Carrier) flight.
     * 
     * @param resFlightNumber
     */
    public void setResFlightNumber(String resFlightNumber) {
        this.resFlightNumber = resFlightNumber;
    }

    /** 
     * Get the 'ResOriginAirportCityCode' element value. This field contains the origin airport/city code of the “Reservation Change” flight.
     * 
     * @return value
     */
    public String getResOriginAirportCityCode() {
        return resOriginAirportCityCode;
    }

    /** 
     * Set the 'ResOriginAirportCityCode' element value. This field contains the origin airport/city code of the “Reservation Change” flight.
     * 
     * @param resOriginAirportCityCode
     */
    public void setResOriginAirportCityCode(String resOriginAirportCityCode) {
        this.resOriginAirportCityCode = resOriginAirportCityCode;
    }

    /** 
     * Get the 'ResBookDesign' element value. This field contains the reservations booking designator (Marketing) of the “Reservation Change” flight.
     * 
     * @return value
     */
    public String getResBookDesign() {
        return resBookDesign;
    }

    /** 
     * Set the 'ResBookDesign' element value. This field contains the reservations booking designator (Marketing) of the “Reservation Change” flight.
     * 
     * @param resBookDesign
     */
    public void setResBookDesign(String resBookDesign) {
        this.resBookDesign = resBookDesign;
    }

    /** 
     * Get the 'ResStatusCode' element value. This field contains the Reservation Status Code of the “Reservation Change” flight.
     * 
     * @return value
     */
    public CodesetType getResStatusCode() {
        return resStatusCode;
    }

    /** 
     * Set the 'ResStatusCode' element value. This field contains the Reservation Status Code of the “Reservation Change” flight.
     * 
     * @param resStatusCode
     */
    public void setResStatusCode(CodesetType resStatusCode) {
        this.resStatusCode = resStatusCode;
    }

    /** 
     * Get the 'ConsumedAtIssuanceInd' attribute value. When true, the coupon is consumed at issuance.
     * 
     * @return value
     */
    public Boolean getConsumedAtIssuanceInd() {
        return consumedAtIssuanceInd;
    }

    /** 
     * Set the 'ConsumedAtIssuanceInd' attribute value. When true, the coupon is consumed at issuance.
     * 
     * @param consumedAtIssuanceInd
     */
    public void setConsumedAtIssuanceInd(Boolean consumedAtIssuanceInd) {
        this.consumedAtIssuanceInd = consumedAtIssuanceInd;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element ref="ns:CurrentAirlineInfo"/>
     *   &lt;xs:element ref="ns:CheckedInAirlineInfo"/>
     *   &lt;xs:element ref="ns:FlownAirlineInfo"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int CURRENT_AIRLINE_INFO_CHOICE = 0;
        private static final int CHECKED_IN_AIRLINE_INFO_CHOICE = 1;
        private static final int FLOWN_AIRLINE_INFO_CHOICE = 2;
        private CurrentAirlineInfo currentAirlineInfo;
        private CheckedInAirlineInfo checkedInAirlineInfo;
        private FlownAirlineInfo flownAirlineInfo;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if CurrentAirlineInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCurrentAirlineInfo() {
            return choiceSelect == CURRENT_AIRLINE_INFO_CHOICE;
        }

        /** 
         * Get the 'CurrentAirlineInfo' element value.
         * 
         * @return value
         */
        public CurrentAirlineInfo getCurrentAirlineInfo() {
            return currentAirlineInfo;
        }

        /** 
         * Set the 'CurrentAirlineInfo' element value.
         * 
         * @param currentAirlineInfo
         */
        public void setCurrentAirlineInfo(CurrentAirlineInfo currentAirlineInfo) {
            setChoiceSelect(CURRENT_AIRLINE_INFO_CHOICE);
            this.currentAirlineInfo = currentAirlineInfo;
        }

        /** 
         * Check if CheckedInAirlineInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCheckedInAirlineInfo() {
            return choiceSelect == CHECKED_IN_AIRLINE_INFO_CHOICE;
        }

        /** 
         * Get the 'CheckedInAirlineInfo' element value.
         * 
         * @return value
         */
        public CheckedInAirlineInfo getCheckedInAirlineInfo() {
            return checkedInAirlineInfo;
        }

        /** 
         * Set the 'CheckedInAirlineInfo' element value.
         * 
         * @param checkedInAirlineInfo
         */
        public void setCheckedInAirlineInfo(
                CheckedInAirlineInfo checkedInAirlineInfo) {
            setChoiceSelect(CHECKED_IN_AIRLINE_INFO_CHOICE);
            this.checkedInAirlineInfo = checkedInAirlineInfo;
        }

        /** 
         * Check if FlownAirlineInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFlownAirlineInfo() {
            return choiceSelect == FLOWN_AIRLINE_INFO_CHOICE;
        }

        /** 
         * Get the 'FlownAirlineInfo' element value.
         * 
         * @return value
         */
        public FlownAirlineInfo getFlownAirlineInfo() {
            return flownAirlineInfo;
        }

        /** 
         * Set the 'FlownAirlineInfo' element value.
         * 
         * @param flownAirlineInfo
         */
        public void setFlownAirlineInfo(FlownAirlineInfo flownAirlineInfo) {
            setChoiceSelect(FLOWN_AIRLINE_INFO_CHOICE);
            this.flownAirlineInfo = flownAirlineInfo;
        }
    }
    /** 
     * Name and location of service provider that will perform the service described on an EMD coupon.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PresentInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="To"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="At"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PresentInfo implements Serializable
    {
        private String to;
        private String at;

        /** 
         * Get the 'To' attribute value. The name of service provider. Example: ???
         * 
         * @return value
         */
        public String getTo() {
            return to;
        }

        /** 
         * Set the 'To' attribute value. The name of service provider. Example: ???
         * 
         * @param to
         */
        public void setTo(String to) {
            this.to = to;
        }

        /** 
         * Get the 'At' attribute value. The location of the service provider. Example: ???
         * 
         * @return value
         */
        public String getAt() {
            return at;
        }

        /** 
         * Set the 'At' attribute value. The location of the service provider. Example: ???
         * 
         * @param at
         */
        public void setAt(String at) {
            this.at = at;
        }
    }
    /** 
     * Reason for Issuance information.

    Note: This contains the Reason for Issuance Code (RFIC) and Reason for Issuance Subcode (RFISC.)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReasonForIssuance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:RFIC" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReasonForIssuance implements Serializable
    {
        private RFIC RFIC;
        private String code;
        private String description;

        /** 
         * Get the 'RFIC' element value.
         * 
         * @return value
         */
        public RFIC getRFIC() {
            return RFIC;
        }

        /** 
         * Set the 'RFIC' element value.
         * 
         * @param RFIC
         */
        public void setRFIC(RFIC RFIC) {
            this.RFIC = RFIC;
        }

        /** 
         * Get the 'Code' element value. Reason for Issuance Subcode. Example: ???
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Reason for Issuance Subcode. Example: ???
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Description' element value. Corresponding description to the reason for issuance subcode. Example: ???
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Corresponding description to the reason for issuance subcode. Example: ???
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }
    }
    /** 
     * Filed fee information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FiledFeeInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:decimal" use="optional" name="BSR_Rate"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FiledFeeInfo implements Serializable
    {
        private CurrencyAmountOptType amount;
        private BigDecimal BSRRate;

        /** 
         * Get the 'Amount' element value. Filed Fee Amount. Example: 100 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Filed Fee Amount. Example: 100 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'BSR_Rate' attribute value. Bankers Seller Rate. Example: 1.25

        Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
         * 
         * @return value
         */
        public BigDecimal getBSRRate() {
            return BSRRate;
        }

        /** 
         * Set the 'BSR_Rate' attribute value. Bankers Seller Rate. Example: 1.25

        Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
         * 
         * @param BSRRate
         */
        public void setBSRRate(BigDecimal BSRRate) {
            this.BSRRate = BSRRate;
        }
    }
    /** 
     * Contains product characteristics of an optional service, for inclusion on EMD. Includes type (Designates an optional service product characteristic type e.g., t-shirt size, color or pre-reserved seat number); and product characteristic value (Text that describes the product sold for the corresponding Product Characteristic Type, e.g. large, blue.)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductCharacteristic" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProductCharacteristic implements Serializable
    {
        private String type;
        private String description;

        /** 
         * Get the 'Type' element value. Optional Service Product Characteristic. Example: ???

        Note: This identifies the type of optional service product characteristic described in description.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Optional Service Product Characteristic. Example: ???

        Note: This identifies the type of optional service product characteristic described in description.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Description' element value. Product Characteristic Description. Example: ????
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Product Characteristic Description. Example: ????
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }
    }
    /** 
     * Identifies the ATPCO additional services information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalServicesInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Group" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="SubGroup" minOccurs="0"/>
     *       &lt;xs:element type="ns:CodesetType" name="RFISC_DefinedType" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ServiceType" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdditionalServicesInfo implements Serializable
    {
        private String group;
        private String subGroup;
        private CodesetType RFISCDefinedType;
        private String serviceType;

        /** 
         * Get the 'Group' element value. ATPCO Optional Service Group Code. Example: ???

        Note: This is a value which specifies the high-level group applicable to the service at the coupon level as defined by ATPCO.
         * 
         * @return value
         */
        public String getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' element value. ATPCO Optional Service Group Code. Example: ???

        Note: This is a value which specifies the high-level group applicable to the service at the coupon level as defined by ATPCO.
         * 
         * @param group
         */
        public void setGroup(String group) {
            this.group = group;
        }

        /** 
         * Get the 'SubGroup' element value. ATPCO Optional Service Sub Group Code. Example: ???

        Note: This is a value which specifies the sub group (within the specified group) applicable to the service at the coupon level as defined by ATPCO.
         * 
         * @return value
         */
        public String getSubGroup() {
            return subGroup;
        }

        /** 
         * Set the 'SubGroup' element value. ATPCO Optional Service Sub Group Code. Example: ???

        Note: This is a value which specifies the sub group (within the specified group) applicable to the service at the coupon level as defined by ATPCO.
         * 
         * @param subGroup
         */
        public void setSubGroup(String subGroup) {
            this.subGroup = subGroup;
        }

        /** 
         * Get the 'RFISC_DefinedType' element value. RFISC Issuance Type. Example: ZZZ (Mutually Defined)

        Encoding Scheme: IATA Padis Codeset - List for data element 1131 (Code List Qualifier)

        PAULA: Is the right code set?
         * 
         * @return value
         */
        public CodesetType getRFISCDefinedType() {
            return RFISCDefinedType;
        }

        /** 
         * Set the 'RFISC_DefinedType' element value. RFISC Issuance Type. Example: ZZZ (Mutually Defined)

        Encoding Scheme: IATA Padis Codeset - List for data element 1131 (Code List Qualifier)

        PAULA: Is the right code set?
         * 
         * @param RFISCDefinedType
         */
        public void setRFISCDefinedType(CodesetType RFISCDefinedType) {
            this.RFISCDefinedType = RFISCDefinedType;
        }

        /** 
         * Get the 'ServiceType' element value. ATPCO Service Type Code. Example: ?

        Note: This is a value which specifies the service type.
         * 
         * @return value
         */
        public String getServiceType() {
            return serviceType;
        }

        /** 
         * Set the 'ServiceType' element value. ATPCO Service Type Code. Example: ?

        Note: This is a value which specifies the service type.
         * 
         * @param serviceType
         */
        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }
    }
    /** 
     * Excess baggage information for this coupon.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcessBaggage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
     *       &lt;xs:element type="ns:CodesetType" name="UnitOfMeasureCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:decimal" name="Quantity" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="UnitOfMeasure" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ExcessBaggage implements Serializable
    {
        private CurrencyAmountOptType amount;
        private CodesetType unitOfMeasureCode;
        private BigDecimal quantity;
        private String unitOfMeasure;

        /** 
         * Get the 'Amount' element value. Excess Baggage Amount. Example: 100 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Excess Baggage Amount. Example: 100 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'UnitOfMeasureCode' element value. Unit of Measure Code. Example: W (Weight)

        Encoding Scheme: IATA Padis Codeset - List for data element 5463 (Allowance or Charge Qualifier)
         * 
         * @return value
         */
        public CodesetType getUnitOfMeasureCode() {
            return unitOfMeasureCode;
        }

        /** 
         * Set the 'UnitOfMeasureCode' element value. Unit of Measure Code. Example: W (Weight)

        Encoding Scheme: IATA Padis Codeset - List for data element 5463 (Allowance or Charge Qualifier)
         * 
         * @param unitOfMeasureCode
         */
        public void setUnitOfMeasureCode(CodesetType unitOfMeasureCode) {
            this.unitOfMeasureCode = unitOfMeasureCode;
        }

        /** 
         * Get the 'Quantity' element value. Excess Baggage Unit Quantity. Example: 10
         * 
         * @return value
         */
        public BigDecimal getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' element value. Excess Baggage Unit Quantity. Example: 10
         * 
         * @param quantity
         */
        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        /** 
         * Get the 'UnitOfMeasure' element value. Excess Baggage Unit of Measure. Example: Pounds

        Note: This is a standard unit of measure name (e.g., it could be generic such as metric or imperial or specific such as inches, feet, yards, miles, millimeters, centimeters, meters, kilometers- according to usage). 
         * 
         * @return value
         */
        public String getUnitOfMeasure() {
            return unitOfMeasure;
        }

        /** 
         * Set the 'UnitOfMeasure' element value. Excess Baggage Unit of Measure. Example: Pounds

        Note: This is a standard unit of measure name (e.g., it could be generic such as metric or imperial or specific such as inches, feet, yards, miles, millimeters, centimeters, meters, kilometers- according to usage). 
         * 
         * @param unitOfMeasure
         */
        public void setUnitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
        }
    }
}
