
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for Coupon Cancel Function. Examples: OriginalIssue, Exchange, Refund

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CpnCancelFunctionListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OriginalIssue"/>
 *     &lt;xs:enumeration value="Exchange"/>
 *     &lt;xs:enumeration value="Refund"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CpnCancelFunctionListType implements Serializable {
    ORIGINAL_ISSUE("OriginalIssue"), EXCHANGE("Exchange"), REFUND("Refund");
    private final String value;

    private CpnCancelFunctionListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CpnCancelFunctionListType convert(String value) {
        for (CpnCancelFunctionListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
