
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Program ACS Customer Authentication contextual list. Examples: Y- Customer authenticated N- Customer not authenticated A- An authentication attempt occurred but could not be completed U- Unable to perform authentication

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerAuthStatusListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="A"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value="U"/>
 *     &lt;xs:enumeration value="Y"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CustomerAuthStatusListType implements Serializable {
    /** 
     * 
    A- An authentication attempt occurred but could not be completed
    
     */
    A, /** 
        * N- Customer not authenticated
        */
    N, /** 
        * U- Unable to perform authentication
        */
    U, /** 
        * Y- Customer authenticated
        */
    Y
}
