
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * A data type definition for Effective/ Expiration Short Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatePeriodType">
 *   &lt;xs:attribute type="xs:date" use="optional" name="Effective"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="Expiration"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatePeriodType implements Serializable
{
    private Date effective;
    private Date expiration;

    /** 
     * Get the 'Effective' attribute value. Effective (start) Date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' attribute value. Effective (start) Date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param effective
     */
    public void setEffective(Date effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' attribute value. Expiration (end) Date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' attribute value. Expiration (end) Date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param expiration
     */
    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }
}
