
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Distance Unit of Measure contextual list.
 Examples: Miles, Kilometers
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DistanceUnitListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Feet"/>
 *     &lt;xs:enumeration value="Kilometers"/>
 *     &lt;xs:enumeration value="Meters"/>
 *     &lt;xs:enumeration value="Miles"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DistanceUnitListType implements Serializable {
    FEET("Feet"), /** 
                   * K = KILOMETERS
                   */
    KILOMETERS("Kilometers"), METERS("Meters"), /** 
                                                 * M = MILES
                                                 */
    MILES("Miles"), OTHER("Other");
    private final String value;

    private DistanceUnitListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DistanceUnitListType convert(String value) {
        for (DistanceUnitListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
