
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for Enable 3DS Address Verification Data contextual list. Examples: Enable, Disable

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnableAVS_SimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Disable"/>
 *     &lt;xs:enumeration value="Enable"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnableAVSSimpleType implements Serializable {
    DISABLE("Disable"), ENABLE("Enable");
    private final String value;

    private EnableAVSSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnableAVSSimpleType convert(String value) {
        for (EnableAVSSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
