
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for EQUIVALENT IDENTIFIER Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentID_MetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="EquivID" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class EquivID -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EquivalentIDMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private List<EquivID> equivIDList = new ArrayList<EquivID>();

    /** 
     * Get the list of 'EquivID' element items.
     * 
     * @return list
     */
    public List<EquivID> getEquivIDList() {
        return equivIDList;
    }

    /** 
     * Set the list of 'EquivID' element items.
     * 
     * @param list
     */
    public void setEquivIDList(List<EquivID> list) {
        equivIDList = list;
    }
    /** 
     * Equivalent Identifier detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivID" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:EquivalentID_Key"/>
     *       &lt;xs:element type="xs:string" name="ID_Value"/>
     *       &lt;xs:element type="xs:string" name="Owner"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:MetadataObjAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EquivID implements Serializable
    {
        private EquivalentIDKey equivalentIDKey;
        private String IDValue;
        private String owner;
        private MetadataObjAttrGroup metadataObjAttrGroup;

        /** 
         * Get the 'EquivalentID_Key' element value.
         * 
         * @return value
         */
        public EquivalentIDKey getEquivalentIDKey() {
            return equivalentIDKey;
        }

        /** 
         * Set the 'EquivalentID_Key' element value.
         * 
         * @param equivalentIDKey
         */
        public void setEquivalentIDKey(EquivalentIDKey equivalentIDKey) {
            this.equivalentIDKey = equivalentIDKey;
        }

        /** 
         * Get the 'ID_Value' element value. Equivalent ID value. Example: MYSRVC123
         * 
         * @return value
         */
        public String getIDValue() {
            return IDValue;
        }

        /** 
         * Set the 'ID_Value' element value. Equivalent ID value. Example: MYSRVC123
         * 
         * @param IDValue
         */
        public void setIDValue(String IDValue) {
            this.IDValue = IDValue;
        }

        /** 
         * Get the 'Owner' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'MetadataObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public MetadataObjAttrGroup getMetadataObjAttrGroup() {
            return metadataObjAttrGroup;
        }

        /** 
         * Set the 'MetadataObjAttrGroup' attributeGroup value.
         * 
         * @param metadataObjAttrGroup
         */
        public void setMetadataObjAttrGroup(
                MetadataObjAttrGroup metadataObjAttrGroup) {
            this.metadataObjAttrGroup = metadataObjAttrGroup;
        }
    }
}
