
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * EXISTING ORDER Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExistingOrderQualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:OrderQualiferType">
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:TravelerReferences"/>
 *           &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ExistingOrderQualifier extends OrderQualiferType implements
    Serializable
{
    private TravelerReferences travelerReferences;
    private BookingReferenceType bookingReference;

    /** 
     * Get the 'TravelerReferences' element value.
     * 
     * @return value
     */
    public TravelerReferences getTravelerReferences() {
        return travelerReferences;
    }

    /** 
     * Set the 'TravelerReferences' element value.
     * 
     * @param travelerReferences
     */
    public void setTravelerReferences(TravelerReferences travelerReferences) {
        this.travelerReferences = travelerReferences;
    }

    /** 
     * Get the 'BookingReference' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferenceType getBookingReference() {
        return bookingReference;
    }

    /** 
     * Set the 'BookingReference' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param bookingReference
     */
    public void setBookingReference(BookingReferenceType bookingReference) {
        this.bookingReference = bookingReference;
    }
}
