
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FQTV PROGRAM ALLIANCE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FQTV_AllianceType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:UniqueIDContextType" name="Code"/>
 *         &lt;xs:element type="xs:string" name="URL" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element name="Participants" minOccurs="0">
 *           &lt;!-- Reference to inner class Participants -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FQTVAllianceType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private UniqueIDContextType code;
    private String URL;
    private String name;
    private Participants participants;

    /** 
     * Get the 'Code' element value. Used to specify the alliance CodeSet. Refer to IATA PADIS Code List for data element 9906. Used in conjunction with Name (Alliance Name) and Participants (Alliance Particiaption information)
     * 
     * @return value
     */
    public UniqueIDContextType getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Used to specify the alliance CodeSet. Refer to IATA PADIS Code List for data element 9906. Used in conjunction with Name (Alliance Name) and Participants (Alliance Particiaption information)
     * 
     * @param code
     */
    public void setCode(UniqueIDContextType code) {
        this.code = code;
    }

    /** 
     * Get the 'URL' element value. Alliance information URL.
    Example: http://www.oneworld.com/home
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Alliance information URL.
    Example: http://www.oneworld.com/home
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'Name' element value. Alliance name. Example: One World Alliance
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Alliance name. Example: One World Alliance
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Participants' element value.
     * 
     * @return value
     */
    public Participants getParticipants() {
        return participants;
    }

    /** 
     * Set the 'Participants' element value.
     * 
     * @param participants
     */
    public void setParticipants(Participants participants) {
        this.participants = participants;
    }
    /** 
     * "Alliance Participation information.  Used in conjunction with Code (Unique Alliance code or ID-OWA
    and Name (Alliance Name-One World Alliance)."
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Participants" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Participant" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Participant -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Participants implements Serializable
    {
        private List<Participant> participantList = new ArrayList<Participant>();

        /** 
         * Get the list of 'Participant' element items.
         * 
         * @return list
         */
        public List<Participant> getParticipantList() {
            return participantList;
        }

        /** 
         * Set the list of 'Participant' element items.
         * 
         * @param list
         */
        public void setParticipantList(List<Participant> list) {
            participantList = list;
        }
        /** 
         * Participant detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Participant" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:ParticipatingAirline"/>
         *       &lt;xs:element ref="ns:ParticipatingProgram"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Participant implements Serializable
        {
            private AllianceAirlinePartyType participatingAirline;
            private AllianceProgramType participatingProgram;

            /** 
             * Get the 'ParticipatingAirline' element value. Identifies a particular Airline participant in an Alliance in view of an FQTV program details.
             * 
             * @return value
             */
            public AllianceAirlinePartyType getParticipatingAirline() {
                return participatingAirline;
            }

            /** 
             * Set the 'ParticipatingAirline' element value. Identifies a particular Airline participant in an Alliance in view of an FQTV program details.
             * 
             * @param participatingAirline
             */
            public void setParticipatingAirline(
                    AllianceAirlinePartyType participatingAirline) {
                this.participatingAirline = participatingAirline;
            }

            /** 
             * Get the 'ParticipatingProgram' element value. Identifies a particular affiliated FQTV program in an Alliance in view of an FQTV program details.
             * 
             * @return value
             */
            public AllianceProgramType getParticipatingProgram() {
                return participatingProgram;
            }

            /** 
             * Set the 'ParticipatingProgram' element value. Identifies a particular affiliated FQTV program in an Alliance in view of an FQTV program details.
             * 
             * @param participatingProgram
             */
            public void setParticipatingProgram(
                    AllianceProgramType participatingProgram) {
                this.participatingProgram = participatingProgram;
            }
        }
    }
}
