
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Core Frequent Traveler Program.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FQTV_ProgramCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:FQTV_ProgramID"/>
 *         &lt;xs:element name="ProviderID" minOccurs="0">
 *           &lt;!-- Reference to inner class ProviderID -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Account" minOccurs="0">
 *           &lt;!-- Reference to inner class Account -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Tier" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="TierName"/>
 *               &lt;xs:element name="TierCode"/>
 *               &lt;xs:element name="Priority"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FQTVProgramCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private FQTVProgramID FQTVProgramID;
    private ProviderID providerID;
    private Account account;

    /** 
     * Get the 'FQTV_ProgramID' element value.
     * 
     * @return value
     */
    public FQTVProgramID getFQTVProgramID() {
        return FQTVProgramID;
    }

    /** 
     * Set the 'FQTV_ProgramID' element value.
     * 
     * @param FQTVProgramID
     */
    public void setFQTVProgramID(FQTVProgramID FQTVProgramID) {
        this.FQTVProgramID = FQTVProgramID;
    }

    /** 
     * Get the 'ProviderID' element value.
     * 
     * @return value
     */
    public ProviderID getProviderID() {
        return providerID;
    }

    /** 
     * Set the 'ProviderID' element value.
     * 
     * @param providerID
     */
    public void setProviderID(ProviderID providerID) {
        this.providerID = providerID;
    }

    /** 
     * Get the 'Account' element value.
     * 
     * @return value
     */
    public Account getAccount() {
        return account;
    }

    /** 
     * Set the 'Account' element value.
     * 
     * @param account
     */
    public void setAccount(Account account) {
        this.account = account;
    }
    /** 
     *  Non airline loyalty information eg Avios.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProviderID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="refs"/>
     *         &lt;xs:attribute type="xs:string" name="ObjectMetaReferences"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProviderID implements Serializable
    {
        private String string;
        private String refs;
        private String objectMetaReferences;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this  object and any object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this  object and any object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
         * 
         * @return value
         */
        public String getObjectMetaReferences() {
            return objectMetaReferences;
        }

        /** 
         * Set the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
         * 
         * @param objectMetaReferences
         */
        public void setObjectMetaReferences(String objectMetaReferences) {
            this.objectMetaReferences = objectMetaReferences;
        }
    }
    /** 
     * Traveler FQTV Account information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SignInID" minOccurs="0">
     *         &lt;!-- Reference to inner class SignInID -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Number">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Account implements Serializable
    {
        private SignInID signInID;
        private String numberString;
        private String numberRefs;
        private String refs;

        /** 
         * Get the 'SignInID' element value.
         * 
         * @return value
         */
        public SignInID getSignInID() {
            return signInID;
        }

        /** 
         * Set the 'SignInID' element value.
         * 
         * @param signInID
         */
        public void setSignInID(SignInID signInID) {
            this.signInID = signInID;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getNumberString() {
            return numberString;
        }

        /** 
         * Set the extension value.
         * 
         * @param numberString
         */
        public void setNumberString(String numberString) {
            this.numberString = numberString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getNumberRefs() {
            return numberRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param numberRefs
         */
        public void setNumberRefs(String numberRefs) {
            this.numberRefs = numberRefs;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Traveler FQTV program sign in (or user) ID.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignInID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class SignInID implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
