
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Summary Frequent Traveler Program.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FQTV_ProgramSummaryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:FQTV_ProgramCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="URL" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FQTVProgramSummaryType extends FQTVProgramCoreType implements
    Serializable
{
    private String URL;
    private String name;

    /** 
     * Get the 'URL' element value. FQTV Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. FQTV Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'Name' element value. Program Name.  Example: Miles and More
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Program Name.  Example: Miles and More
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
