
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for Factor Authentication Type contextual list. Examples: OneTimeCode, PatternBasedGrid, RandomCharacter

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FactorAuthListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OneTimeCode"/>
 *     &lt;xs:enumeration value="PinPhrase"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FactorAuthListType implements Serializable {
    /** 
     * 
    OATH-compliant One Time Code generation for sending a one-time code to a Traveler's mobile phone as a Text/SMS/Email.
    
     */
    ONE_TIME_CODE("OneTimeCode"), /** 
                                   * 
                                  Random Character Pin Phrase Authentication prompts a user to enter the random characters from their specified password.
                                  
                                   */
    PIN_PHRASE("PinPhrase");
    private final String value;

    private FactorAuthListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FactorAuthListType convert(String value) {
        for (FactorAuthListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
