
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Fare Amount Type list 

 Examples: BT (Bulk); IT (Tour Inclusive)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareAmountType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ADC"/>
 *     &lt;xs:enumeration value="Bulk"/>
 *     &lt;xs:enumeration value="IT"/>
 *     &lt;xs:enumeration value="NOADC"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FareAmountType implements Serializable {
    /** 
     * Additional collection
     */
    ADC("ADC"), BULK("Bulk"), IT("IT"), NOADC("NOADC");
    private final String value;

    private FareAmountType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FareAmountType convert(String value) {
        for (FareAmountType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
