
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A repeatable field containing a string of data reflecting the fare construction applicable to the transaction and, when applicable, the breakdown for Passenger Facility Charges and U.S. Flight Segment Taxes. This represents the fare calculation as it would appear on a paper flight coupon.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="FareCalculation"/>
 * </pre>
 */
public class FareCalculation implements Serializable
{
    private String fareCalculation;

    /** 
     * Get the 'FareCalculation' element value.
     * 
     * @return value
     */
    public String getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' element value.
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(String fareCalculation) {
        this.fareCalculation = fareCalculation;
    }
}
