
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * FARE COMPONENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Parameters" minOccurs="0">
 *           &lt;!-- Reference to inner class Parameters -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:SegmentReference" minOccurs="0"/>
 *         &lt;xs:element name="PriceBreakdown" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="ns:FarePriceDetailType" name="Price"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="FareBasis" minOccurs="0">
 *           &lt;!-- Reference to inner class FareBasis -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:TicketDesig" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FareRules" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareComponentType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Parameters parameters;
    private SegmentReference segmentReference;
    private FarePriceDetailType priceBreakdown;
    private FareBasis fareBasis;
    private TicketDesignatorType ticketDesig;
    private FareRulesType fareRules;

    /** 
     * Get the 'Parameters' element value.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'SegmentReference' element value.
     * 
     * @return value
     */
    public SegmentReference getSegmentReference() {
        return segmentReference;
    }

    /** 
     * Set the 'SegmentReference' element value.
     * 
     * @param segmentReference
     */
    public void setSegmentReference(SegmentReference segmentReference) {
        this.segmentReference = segmentReference;
    }

    /** 
     * Get the 'Price' element value. Price Break-down per Fare Component.
     * 
     * @return value
     */
    public FarePriceDetailType getPriceBreakdown() {
        return priceBreakdown;
    }

    /** 
     * Set the 'Price' element value. Price Break-down per Fare Component.
     * 
     * @param priceBreakdown
     */
    public void setPriceBreakdown(FarePriceDetailType priceBreakdown) {
        this.priceBreakdown = priceBreakdown;
    }

    /** 
     * Get the 'FareBasis' element value.
     * 
     * @return value
     */
    public FareBasis getFareBasis() {
        return fareBasis;
    }

    /** 
     * Set the 'FareBasis' element value.
     * 
     * @param fareBasis
     */
    public void setFareBasis(FareBasis fareBasis) {
        this.fareBasis = fareBasis;
    }

    /** 
     * Get the 'TicketDesig' element value.
     * 
     * @return value
     */
    public TicketDesignatorType getTicketDesig() {
        return ticketDesig;
    }

    /** 
     * Set the 'TicketDesig' element value.
     * 
     * @param ticketDesig
     */
    public void setTicketDesig(TicketDesignatorType ticketDesig) {
        this.ticketDesig = ticketDesig;
    }

    /** 
     * Get the 'FareRules' element value.
     * 
     * @return value
     */
    public FareRulesType getFareRules() {
        return fareRules;
    }

    /** 
     * Set the 'FareRules' element value.
     * 
     * @param fareRules
     */
    public void setFareRules(FareRulesType fareRules) {
        this.fareRules = fareRules;
    }
    /** 
     * Fare Component-related parameters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String quantity;

        /** 
         * Get the 'Quantity' attribute value. The total number of fare components within the fare component calculation. Example: 2
         * 
         * @return value
         */
        public String getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' attribute value. The total number of fare components within the fare component calculation. Example: 2
         * 
         * @param quantity
         */
        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Fare Basis information, including Fare Basis Code, Fare Rule Remarks and Fare Basis City Pair.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareRulesRemarks" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareBasisCityPair" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="RBD" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareBasis implements Serializable
    {
        private FareBasisCodeType fareBasisCode;
        private FareRulesRemarks fareRulesRemarks;
        private FareBasisCityPair fareBasisCityPair;
        private String RBD;

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'FareRulesRemarks' element value.
         * 
         * @return value
         */
        public FareRulesRemarks getFareRulesRemarks() {
            return fareRulesRemarks;
        }

        /** 
         * Set the 'FareRulesRemarks' element value.
         * 
         * @param fareRulesRemarks
         */
        public void setFareRulesRemarks(FareRulesRemarks fareRulesRemarks) {
            this.fareRulesRemarks = fareRulesRemarks;
        }

        /** 
         * Get the 'FareBasisCityPair' element value.
         * 
         * @return value
         */
        public FareBasisCityPair getFareBasisCityPair() {
            return fareBasisCityPair;
        }

        /** 
         * Set the 'FareBasisCityPair' element value.
         * 
         * @param fareBasisCityPair
         */
        public void setFareBasisCityPair(FareBasisCityPair fareBasisCityPair) {
            this.fareBasisCityPair = fareBasisCityPair;
        }

        /** 
         * Get the 'RBD' element value. Reservation Booking Designator or Booking Class e.g. T
         * 
         * @return value
         */
        public String getRBD() {
            return RBD;
        }

        /** 
         * Set the 'RBD' element value. Reservation Booking Designator or Booking Class e.g. T
         * 
         * @param RBD
         */
        public void setRBD(String RBD) {
            this.RBD = RBD;
        }
    }
}
