
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FARE DETAIL definition.NDC Capability Model: FARE - FARE DETAIL

 ============
 Representation(s)
 ============
 • Fare Component information
 • Fare Rules information

 ============
 Feature(s)
 ============
 • Fare Code Indicator to represent pricing method (IATA PADIS Code List for data element 5387 - Price Type Qualifier)
 • Price Class association
 • Associated Flight Mileage
 • Fare Remarks
 • Tour Code support (A special code arranged between the travel agency and the sales representative for a particular airline. When the agent enters the tour code into the reservation and ticketing system, it will input certain information onto the ticket. For example, agent commisions, specific fare fules that supercede the published fare rules etc.)

 ============
 Metadata
 ============
 • FareMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CodesetType" name="FareIndicatorCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FareComponent" maxOccurs="unbounded"/>
 *         &lt;xs:element ref="ns:PriceClassReference" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FlightMileage" minOccurs="0"/>
 *         &lt;xs:element ref="ns:TourCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareDetailType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private CodesetType fareIndicatorCode;
    private List<FareComponentType> fareComponentList = new ArrayList<FareComponentType>();
    private PriceClassReference priceClassReference;
    private FlightMileageType flightMileage;
    private TourCode tourCode;
    private Remarks remarks;

    /** 
     * Get the 'FareIndicatorCode' element value. Fare code indicator.  Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION)

    Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier
     * 
     * @return value
     */
    public CodesetType getFareIndicatorCode() {
        return fareIndicatorCode;
    }

    /** 
     * Set the 'FareIndicatorCode' element value. Fare code indicator.  Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION)

    Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier
     * 
     * @param fareIndicatorCode
     */
    public void setFareIndicatorCode(CodesetType fareIndicatorCode) {
        this.fareIndicatorCode = fareIndicatorCode;
    }

    /** 
     * Get the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @return list
     */
    public List<FareComponentType> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentType> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'PriceClassReference' element value. Associated Price Class.
     * 
     * @return value
     */
    public PriceClassReference getPriceClassReference() {
        return priceClassReference;
    }

    /** 
     * Set the 'PriceClassReference' element value. Associated Price Class.
     * 
     * @param priceClassReference
     */
    public void setPriceClassReference(PriceClassReference priceClassReference) {
        this.priceClassReference = priceClassReference;
    }

    /** 
     * Get the 'FlightMileage' element value.
     * 
     * @return value
     */
    public FlightMileageType getFlightMileage() {
        return flightMileage;
    }

    /** 
     * Set the 'FlightMileage' element value.
     * 
     * @param flightMileage
     */
    public void setFlightMileage(FlightMileageType flightMileage) {
        this.flightMileage = flightMileage;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
}
