
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FARE RULES definition.NDC Capability Model: FARE - FARE DETAIL- FARE RULES

 ============
 Feature(s)
 ============
 • Fare Penalty information
 • Corporate Fare information
 • Advance Ticketing, Purchase, Minimum and Maximum Stay Requirements
 • Ticketing Instructions
 • Fare Rule Remarks

 ============
 Metadata
 ============
 • FareRuleMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRulesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Penalty" minOccurs="0"/>
 *         &lt;xs:element ref="ns:CorporateFare" minOccurs="0"/>
 *         &lt;xs:element name="AdvanceStay" minOccurs="0">
 *           &lt;!-- Reference to inner class AdvanceStay -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Ticketing" minOccurs="0">
 *           &lt;!-- Reference to inner class Ticketing -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareRulesType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Penalty penalty;
    private CorporateFare corporateFare;
    private AdvanceStay advanceStay;
    private Ticketing ticketing;
    private Remarks remarks;

    /** 
     * Get the 'Penalty' element value.
     * 
     * @return value
     */
    public Penalty getPenalty() {
        return penalty;
    }

    /** 
     * Set the 'Penalty' element value.
     * 
     * @param penalty
     */
    public void setPenalty(Penalty penalty) {
        this.penalty = penalty;
    }

    /** 
     * Get the 'CorporateFare' element value.
     * 
     * @return value
     */
    public CorporateFare getCorporateFare() {
        return corporateFare;
    }

    /** 
     * Set the 'CorporateFare' element value.
     * 
     * @param corporateFare
     */
    public void setCorporateFare(CorporateFare corporateFare) {
        this.corporateFare = corporateFare;
    }

    /** 
     * Get the 'AdvanceStay' element value.
     * 
     * @return value
     */
    public AdvanceStay getAdvanceStay() {
        return advanceStay;
    }

    /** 
     * Set the 'AdvanceStay' element value.
     * 
     * @param advanceStay
     */
    public void setAdvanceStay(AdvanceStay advanceStay) {
        this.advanceStay = advanceStay;
    }

    /** 
     * Get the 'Ticketing' element value.
     * 
     * @return value
     */
    public Ticketing getTicketing() {
        return ticketing;
    }

    /** 
     * Set the 'Ticketing' element value.
     * 
     * @param ticketing
     */
    public void setTicketing(Ticketing ticketing) {
        this.ticketing = ticketing;
    }

    /** 
     * Get the 'Remarks' element value. Fare Remark(s).
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value. Fare Remark(s).
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Advance Ticketing, Advance Purchase, Minimum Stay and Maximum Stay.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvanceStay" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AdvancePurchase" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AdvanceTicketing" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MinimumStay" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MaximumStay" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdvanceStay implements Serializable
    {
        private AdvancePurchase advancePurchase;
        private AdvanceTicketing advanceTicketing;
        private MinimumStay minimumStay;
        private MaximumStay maximumStay;

        /** 
         * Get the 'AdvancePurchase' element value.
         * 
         * @return value
         */
        public AdvancePurchase getAdvancePurchase() {
            return advancePurchase;
        }

        /** 
         * Set the 'AdvancePurchase' element value.
         * 
         * @param advancePurchase
         */
        public void setAdvancePurchase(AdvancePurchase advancePurchase) {
            this.advancePurchase = advancePurchase;
        }

        /** 
         * Get the 'AdvanceTicketing' element value.
         * 
         * @return value
         */
        public AdvanceTicketing getAdvanceTicketing() {
            return advanceTicketing;
        }

        /** 
         * Set the 'AdvanceTicketing' element value.
         * 
         * @param advanceTicketing
         */
        public void setAdvanceTicketing(AdvanceTicketing advanceTicketing) {
            this.advanceTicketing = advanceTicketing;
        }

        /** 
         * Get the 'MinimumStay' element value.
         * 
         * @return value
         */
        public MinimumStay getMinimumStay() {
            return minimumStay;
        }

        /** 
         * Set the 'MinimumStay' element value.
         * 
         * @param minimumStay
         */
        public void setMinimumStay(MinimumStay minimumStay) {
            this.minimumStay = minimumStay;
        }

        /** 
         * Get the 'MaximumStay' element value.
         * 
         * @return value
         */
        public MaximumStay getMaximumStay() {
            return maximumStay;
        }

        /** 
         * Set the 'MaximumStay' element value.
         * 
         * @param maximumStay
         */
        public void setMaximumStay(MaximumStay maximumStay) {
            this.maximumStay = maximumStay;
        }
    }
    /** 
     * Ticketing information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:boolean" name="TicketlessInd" minOccurs="0"/>
     *       &lt;xs:element ref="ns:InstantPurchase" minOccurs="0"/>
     *       &lt;xs:element name="Endorsements" minOccurs="0">
     *         &lt;!-- Reference to inner class Endorsements -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Ticketing implements Serializable
    {
        private Boolean ticketlessInd;
        private InstantPurchase instantPurchase;
        private Endorsements endorsements;

        /** 
         * Get the 'TicketlessInd' element value. When TRUE, the Fare can be Purchased Without Issuing a Ticket.
         * 
         * @return value
         */
        public Boolean getTicketlessInd() {
            return ticketlessInd;
        }

        /** 
         * Set the 'TicketlessInd' element value. When TRUE, the Fare can be Purchased Without Issuing a Ticket.
         * 
         * @param ticketlessInd
         */
        public void setTicketlessInd(Boolean ticketlessInd) {
            this.ticketlessInd = ticketlessInd;
        }

        /** 
         * Get the 'InstantPurchase' element value.
         * 
         * @return value
         */
        public InstantPurchase getInstantPurchase() {
            return instantPurchase;
        }

        /** 
         * Set the 'InstantPurchase' element value.
         * 
         * @param instantPurchase
         */
        public void setInstantPurchase(InstantPurchase instantPurchase) {
            this.instantPurchase = instantPurchase;
        }

        /** 
         * Get the 'Endorsements' element value.
         * 
         * @return value
         */
        public Endorsements getEndorsements() {
            return endorsements;
        }

        /** 
         * Set the 'Endorsements' element value.
         * 
         * @param endorsements
         */
        public void setEndorsements(Endorsements endorsements) {
            this.endorsements = endorsements;
        }
        /** 
         * Remarks provided to ensure common understanding between the passenger and an Airline when a fare is restricted as to time of travel, period of validity, voluntary rerouting, or where any other restricting conditions are applicable which are not otherwise clearly evident from other entries

         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Endorsement" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Endorsements implements Serializable
        {
            private List<String> endorsementList = new ArrayList<String>();

            /** 
             * Get the list of 'Endorsement' element items. Ticket endorsement text.
            Example: NONREF
             * 
             * @return list
             */
            public List<String> getEndorsementList() {
                return endorsementList;
            }

            /** 
             * Set the list of 'Endorsement' element items. Ticket endorsement text.
            Example: NONREF
             * 
             * @param list
             */
            public void setEndorsementList(List<String> list) {
                endorsementList = list;
            }
        }
    }
}
