
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * FARE definition.NDC Capability Model: FARE

 ============
 Representation(s)
 ============
 • Core Fare information
 • Detail Fare information (Fare Component, Fare Rules)

 ============
 Feature(s)
 ============
 • Fare Indicators for Cat35 Fare, Reissue Pricing, Auto Exchange Pricing
 • Fare Code (PADIS codeset element 9910 - Fare Qualifier)

 ============
 Metadata
 ============
 • FareMetadata

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:FareCode"/>
 *         &lt;xs:element ref="ns:FareDetail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareType extends KeyWithMetaObjectBaseType implements Serializable
{
    private FareCode fareCode;
    private FareDetailType fareDetail;

    /** 
     * Get the 'FareCode' element value.
     * 
     * @return value
     */
    public FareCode getFareCode() {
        return fareCode;
    }

    /** 
     * Set the 'FareCode' element value.
     * 
     * @param fareCode
     */
    public void setFareCode(FareCode fareCode) {
        this.fareCode = fareCode;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }
}
