
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * FLIGHT DEPARTURE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDepartureType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="AirportCode">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:date" name="Date"/>
 *         &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="AirportName" minOccurs="0"/>
 *         &lt;xs:element name="Terminal" minOccurs="0">
 *           &lt;!-- Reference to inner class Terminal -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightDepartureType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String airportCodeString;
    private RadiusAttrGroup airportCodeRadiusAttrGroup;
    private Date date;
    private String time1;
    private String airportName;
    private Terminal terminal;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getAirportCodeString() {
        return airportCodeString;
    }

    /** 
     * Set the extension value.
     * 
     * @param airportCodeString
     */
    public void setAirportCodeString(String airportCodeString) {
        this.airportCodeString = airportCodeString;
    }

    /** 
     * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
     * 
     * @return value
     */
    public RadiusAttrGroup getAirportCodeRadiusAttrGroup() {
        return airportCodeRadiusAttrGroup;
    }

    /** 
     * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
     * 
     * @param airportCodeRadiusAttrGroup
     */
    public void setAirportCodeRadiusAttrGroup(
            RadiusAttrGroup airportCodeRadiusAttrGroup) {
        this.airportCodeRadiusAttrGroup = airportCodeRadiusAttrGroup;
    }

    /** 
     * Get the 'Date' element value. Departure date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Departure date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'Time' element value. Departure time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @return value
     */
    public String getTime1() {
        return time1;
    }

    /** 
     * Set the 'Time' element value. Departure time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @param time1
     */
    public void setTime1(String time1) {
        this.time1 = time1;
    }

    /** 
     * Get the 'AirportName' element value. Airport Name. Example: Tampa International
     * 
     * @return value
     */
    public String getAirportName() {
        return airportName;
    }

    /** 
     * Set the 'AirportName' element value. Airport Name. Example: Tampa International
     * 
     * @param airportName
     */
    public void setAirportName(String airportName) {
        this.airportName = airportName;
    }

    /** 
     * Get the 'Terminal' element value.
     * 
     * @return value
     */
    public Terminal getTerminal() {
        return terminal;
    }

    /** 
     * Set the 'Terminal' element value.
     * 
     * @param terminal
     */
    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }
    /** 
     * Airport terminal name and gate.
    Refer to IATA SSIM Appendix D for terminal codes and terminal names.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Terminal" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Gate" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Terminal implements Serializable
    {
        private String name;
        private String gate;

        /** 
         * Get the 'Name' element value. Terminal name or ID.  Example: Terminal C
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Terminal name or ID.  Example: Terminal C
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Gate' element value. Terminal Gate Number.  Example: C39
         * 
         * @return value
         */
        public String getGate() {
            return gate;
        }

        /** 
         * Set the 'Gate' element value. Terminal Gate Number.  Example: C39
         * 
         * @param gate
         */
        public void setGate(String gate) {
            this.gate = gate;
        }
    }
}
