
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Flight Duration Application contextual list.
 Examples: FlightTime, ConnectionTime, StopTime, TotalJourneyTime
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDurationListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ConnectionTime"/>
 *     &lt;xs:enumeration value="FlightTime"/>
 *     &lt;xs:enumeration value="StopTime"/>
 *     &lt;xs:enumeration value="TotalJourneyTime"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FlightDurationListType implements Serializable {
    CONNECTION_TIME("ConnectionTime"), FLIGHT_TIME("FlightTime"), STOP_TIME(
            "StopTime"), TOTAL_JOURNEY_TIME("TotalJourneyTime"), OTHER("Other");
    private final String value;

    private FlightDurationListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FlightDurationListType convert(String value) {
        for (FlightDurationListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
