
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * FLIGHT DURATION with Application definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDurationType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Value"/>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightDurationType extends AssociatedObjectBaseType implements
    Serializable
{
    private String value;
    private String application;

    /** 
     * Get the 'Value' element value. Flight Segment Duration.
    Example: PT6H45M (six hours and forty-five minutes)

    Note: This is the in-flight time duration associated with this segment. Stop duration is specified in the Stops node.
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'Value' element value. Flight Segment Duration.
    Example: PT6H45M (six hours and forty-five minutes)

    Note: This is the in-flight time duration associated with this segment. Stop duration is specified in the Stops node.
     * 
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /** 
     * Get the 'Application' element value. Flight Duration Application.
    Examples: FlightTime, ConnectionTime, TotalJourneyTime
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Flight Duration Application.
    Examples: FlightTime, ConnectionTime, TotalJourneyTime
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }
}
