
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight that the offer applies to.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightInfoAssocType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:boolean" name="AllFlightInd" minOccurs="0"/>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence1 -->
 *     &lt;/xs:sequence>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightInfoAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ALL_FLIGHT_IND_CHOICE = 0;
    private static final int ALL_ORIGIN_DESTINATION_IND_CHOICE = 1;
    private static final int SEQUENCE_CHOICE = 2;
    private Boolean allFlightInd;
    private Sequence allOriginDestinationInd;
    private Sequence1 sequence;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AllFlightInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllFlightInd() {
        return choiceSelect == ALL_FLIGHT_IND_CHOICE;
    }

    /** 
     * Get the 'AllFlightInd' element value. When TRUE, this Simple Fare Offer applies to all specified flights.
     * 
     * @return value
     */
    public Boolean getAllFlightInd() {
        return allFlightInd;
    }

    /** 
     * Set the 'AllFlightInd' element value. When TRUE, this Simple Fare Offer applies to all specified flights.
     * 
     * @param allFlightInd
     */
    public void setAllFlightInd(Boolean allFlightInd) {
        setChoiceSelect(ALL_FLIGHT_IND_CHOICE);
        this.allFlightInd = allFlightInd;
    }

    /** 
     * Check if AllOriginDestinationInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllOriginDestinationInd() {
        return choiceSelect == ALL_ORIGIN_DESTINATION_IND_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getAllOriginDestinationInd() {
        return allOriginDestinationInd;
    }

    /** 
     * Set the sequence value.
     * 
     * @param allOriginDestinationInd
     */
    public void setAllOriginDestinationInd(Sequence allOriginDestinationInd) {
        setChoiceSelect(ALL_ORIGIN_DESTINATION_IND_CHOICE);
        this.allOriginDestinationInd = allOriginDestinationInd;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence1 getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence1 sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:boolean" name="AllOriginDestinationInd" minOccurs="0"/>
     *   &lt;xs:element type="xs:boolean" name="AllSegmentInd" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private Boolean allOriginDestinationInd;
        private Boolean allSegmentInd;

        /** 
         * Get the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @return value
         */
        public Boolean getAllOriginDestinationInd() {
            return allOriginDestinationInd;
        }

        /** 
         * Set the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @param allOriginDestinationInd
         */
        public void setAllOriginDestinationInd(Boolean allOriginDestinationInd) {
            this.allOriginDestinationInd = allOriginDestinationInd;
        }

        /** 
         * Get the 'AllSegmentInd' element value. When TRUE, this Simple Fare Offer applies to all specified flight Segments.
         * 
         * @return value
         */
        public Boolean getAllSegmentInd() {
            return allSegmentInd;
        }

        /** 
         * Set the 'AllSegmentInd' element value. When TRUE, this Simple Fare Offer applies to all specified flight Segments.
         * 
         * @param allSegmentInd
         */
        public void setAllSegmentInd(Boolean allSegmentInd) {
            this.allSegmentInd = allSegmentInd;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element ref="ns:OriginDestinationReferences" minOccurs="0"/>
     *   &lt;xs:element ref="ns:FlightReferences" minOccurs="0"/>
     *   &lt;xs:element ref="ns:FlightSegmentReference" minOccurs="0" maxOccurs="unbounded"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence1 implements Serializable
    {
        private OriginDestinationReferences originDestinationReferences;
        private FlightReferences flightReferences;
        private List<FlightSegmentReference> flightSegmentReferenceList = new ArrayList<FlightSegmentReference>();

        /** 
         * Get the 'OriginDestinationReferences' element value.
         * 
         * @return value
         */
        public OriginDestinationReferences getOriginDestinationReferences() {
            return originDestinationReferences;
        }

        /** 
         * Set the 'OriginDestinationReferences' element value.
         * 
         * @param originDestinationReferences
         */
        public void setOriginDestinationReferences(
                OriginDestinationReferences originDestinationReferences) {
            this.originDestinationReferences = originDestinationReferences;
        }

        /** 
         * Get the 'FlightReferences' element value.
         * 
         * @return value
         */
        public FlightReferences getFlightReferences() {
            return flightReferences;
        }

        /** 
         * Set the 'FlightReferences' element value.
         * 
         * @param flightReferences
         */
        public void setFlightReferences(FlightReferences flightReferences) {
            this.flightReferences = flightReferences;
        }

        /** 
         * Get the list of 'FlightSegmentReference' element items.
         * 
         * @return list
         */
        public List<FlightSegmentReference> getFlightSegmentReferenceList() {
            return flightSegmentReferenceList;
        }

        /** 
         * Set the list of 'FlightSegmentReference' element items.
         * 
         * @param list
         */
        public void setFlightSegmentReferenceList(
                List<FlightSegmentReference> list) {
            flightSegmentReferenceList = list;
        }
    }
}
