
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FLIGHT Order Item.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightItemType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:FlightPriceType" name="Price" minOccurs="0"/>
 *         &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:OrderFareDetailType" name="FareDetail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightItemType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private FlightPriceType price;
    private List<FlightType> originDestinationList = new ArrayList<FlightType>();
    private OrderFareDetailType fareDetail;

    /** 
     * Get the 'Price' element value. Flight Pricing.
     * 
     * @return value
     */
    public FlightPriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Flight Pricing.
     * 
     * @param price
     */
    public void setPrice(FlightPriceType price) {
        this.price = price;
    }

    /** 
     * Get the list of 'OriginDestination' element items. Flight Origin/ Destination information.
     * 
     * @return list
     */
    public List<FlightType> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items. Flight Origin/ Destination information.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<FlightType> list) {
        originDestinationList = list;
    }

    /** 
     * Get the 'FareDetail' element value. Fare Detail.
     * 
     * @return value
     */
    public OrderFareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value. Fare Detail.
     * 
     * @param fareDetail
     */
    public void setFareDetail(OrderFareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }
}
