
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Flight Segment Type list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightMileageListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Arrival"/>
 *     &lt;xs:enumeration value="Departure"/>
 *     &lt;xs:enumeration value="Destination"/>
 *     &lt;xs:enumeration value="Origin"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FlightMileageListType implements Serializable {
    ARRIVAL("Arrival"), DEPARTURE("Departure"), DESTINATION("Destination"), ORIGIN(
            "Origin"), OTHER("Other");
    private final String value;

    private FlightMileageListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FlightMileageListType convert(String value) {
        for (FlightMileageListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
