
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a Flight with no O/D information.

 Flight origin/ destination information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightOnlyType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:SegmentKey" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Departure"/>
 *         &lt;xs:element ref="ns:Arrival"/>
 *         &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingCarrier"/>
 *         &lt;xs:element ref="ns:Equipment" minOccurs="0" maxOccurs="2"/>
 *         &lt;xs:element name="OperatingCarrier" minOccurs="0">
 *           &lt;!-- Reference to inner class OperatingCarrier -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
 *         &lt;xs:element type="ns:FlightDetailType" name="Details" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightOnlyType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private SegmentKey segmentKey;
    private FlightDepartureType departure;
    private FlightArrivalType arrival;
    private MarketingCarrierFlightType marketingCarrier;
    private List<Equipment> equipmentList = new ArrayList<Equipment>();
    private OperatingCarrier operatingCarrier;
    private CabinType cabinType;
    private FlightCOSCoreType classOfService;
    private FlightDetailType details;

    /** 
     * Get the 'SegmentKey' element value.
     * 
     * @return value
     */
    public SegmentKey getSegmentKey() {
        return segmentKey;
    }

    /** 
     * Set the 'SegmentKey' element value.
     * 
     * @param segmentKey
     */
    public void setSegmentKey(SegmentKey segmentKey) {
        this.segmentKey = segmentKey;
    }

    /** 
     * Get the 'Departure' element value.
     * 
     * @return value
     */
    public FlightDepartureType getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value.
     * 
     * @param departure
     */
    public void setDeparture(FlightDepartureType departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value.
     * 
     * @return value
     */
    public FlightArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value.
     * 
     * @param arrival
     */
    public void setArrival(FlightArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'MarketingCarrier' element value. Marketing Carrier information.

    Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
     * 
     * @return value
     */
    public MarketingCarrierFlightType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. Marketing Carrier information.

    Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(MarketingCarrierFlightType marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the list of 'Equipment' element items. Aircraft Equipment.

    Note: Two instances of aircraft equipment may be specified if there is a change of gauge.
     * 
     * @return list
     */
    public List<Equipment> getEquipmentList() {
        return equipmentList;
    }

    /** 
     * Set the list of 'Equipment' element items. Aircraft Equipment.

    Note: Two instances of aircraft equipment may be specified if there is a change of gauge.
     * 
     * @param list
     */
    public void setEquipmentList(List<Equipment> list) {
        equipmentList = list;
    }

    /** 
     * Get the 'OperatingCarrier' element value.
     * 
     * @return value
     */
    public OperatingCarrier getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value.
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'CabinType' element value.
     * 
     * @return value
     */
    public CabinType getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value.
     * 
     * @param cabinType
     */
    public void setCabinType(CabinType cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the 'ClassOfService' element value.
     * 
     * @return value
     */
    public FlightCOSCoreType getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value.
     * 
     * @param classOfService
     */
    public void setClassOfService(FlightCOSCoreType classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'Details' element value. Flight Details.
     * 
     * @return value
     */
    public FlightDetailType getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value. Flight Details.
     * 
     * @param details
     */
    public void setDetails(FlightDetailType details) {
        this.details = details;
    }
    /** 
     * Operating Carrier Information.

    Operating Carrier is the carrier that operates a flight with a reference to its own prime flight number.

    Note: Operating Carrier may be different from a Marketing Carrier(s), if the flight is actually marketed by another carrier(s) within a codeshare agreement. 

    Operating Carrier may not be the AOC holder, in which case, and wherever required, this will need to be disclosed to the customer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OperatingCarrierFlightType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OperatingCarrier extends OperatingCarrierFlightType
        implements Serializable
    {
        private DisclosureType disclosures;

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }
    }
}
