
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FlightPrice transaction set may return two different sets of content. Based on request attributes, the response may initially provide additional a la carte ancillary services that are applicable and available for the selected offer.

 If no ancillary services are available, the message returns a final pricing. If ancillary services are available, the modified pricing request includes selected services and returns a final pricing that includes service(s) selection. The response message also returns multi-media content at the message level with media references at the service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPriceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:FltPriceReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Travelers"/>
 *       &lt;xs:choice>
 *         &lt;xs:element ref="ns:ShoppingResponseIDs"/>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element ref="ns:Preferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Qualifiers" minOccurs="0"/>
 *       &lt;xs:element type="ns:ItineraryType" name="JourneyData" minOccurs="0"/>
 *       &lt;xs:element type="ns:TicketAutoExchangeType" name="InExchangeForTicket" minOccurs="0"/>
 *       &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *       &lt;xs:element type="ns:FltPriceReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FlightPriceRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private FltPriceReqParamsType parameters;
    private Travelers travelers;
    private int choiceSelect = -1;
    private static final int SHOPPING_RESPONSE_I_DS_CHOICE = 0;
    private static final int QUERY_CHOICE = 1;
    private ShoppingResponseIDType shoppingResponseIDs;
    private List<FlightType> queryList = new ArrayList<FlightType>();
    private Preferences preferences;
    private Qualifiers qualifiers;
    private ItineraryType journeyData;
    private TicketAutoExchangeType inExchangeForTicket;
    private DataListType dataLists;
    private FltPriceReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public FltPriceReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(FltPriceReqParamsType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Travelers' element value.
     * 
     * @return value
     */
    public Travelers getTravelers() {
        return travelers;
    }

    /** 
     * Set the 'Travelers' element value.
     * 
     * @param travelers
     */
    public void setTravelers(Travelers travelers) {
        this.travelers = travelers;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ShoppingResponseIDs is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponseIDs() {
        return choiceSelect == SHOPPING_RESPONSE_I_DS_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(SHOPPING_RESPONSE_I_DS_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }

    /** 
     * Check if QueryList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestination' element items. Core Flight Pricing query parameters.
     * 
     * @return list
     */
    public List<FlightType> getQueryList() {
        return queryList;
    }

    /** 
     * Set the list of 'OriginDestination' element items. Core Flight Pricing query parameters.
     * 
     * @param list
     */
    public void setQueryList(List<FlightType> list) {
        setChoiceSelect(QUERY_CHOICE);
        queryList = list;
    }

    /** 
     * Get the 'Preferences' element value.
     * 
     * @return value
     */
    public Preferences getPreferences() {
        return preferences;
    }

    /** 
     * Set the 'Preferences' element value.
     * 
     * @param preferences
     */
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    /** 
     * Get the 'Qualifiers' element value.
     * 
     * @return value
     */
    public Qualifiers getQualifiers() {
        return qualifiers;
    }

    /** 
     * Set the 'Qualifiers' element value.
     * 
     * @param qualifiers
     */
    public void setQualifiers(Qualifiers qualifiers) {
        this.qualifiers = qualifiers;
    }

    /** 
     * Get the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @return value
     */
    public ItineraryType getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @param journeyData
     */
    public void setJourneyData(ItineraryType journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'InExchangeForTicket' element value. Auto Exchange information.
     * 
     * @return value
     */
    public TicketAutoExchangeType getInExchangeForTicket() {
        return inExchangeForTicket;
    }

    /** 
     * Set the 'InExchangeForTicket' element value. Auto Exchange information.
     * 
     * @param inExchangeForTicket
     */
    public void setInExchangeForTicket(
            TicketAutoExchangeType inExchangeForTicket) {
        this.inExchangeForTicket = inExchangeForTicket;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param dataLists
     */
    public void setDataLists(DataListType dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public FltPriceReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(FltPriceReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
}
