
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a Flight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:OriginDestinationKey" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TotalJourney" minOccurs="0"/>
 *     &lt;xs:element name="Flight" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Flight -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightType implements Serializable
{
    private OriginDestinationKey originDestinationKey;
    private TotalJourneyType totalJourney;
    private List<Flight> flightList = new ArrayList<Flight>();
    private String refs;

    /** 
     * Get the 'OriginDestinationKey' element value.
     * 
     * @return value
     */
    public OriginDestinationKey getOriginDestinationKey() {
        return originDestinationKey;
    }

    /** 
     * Set the 'OriginDestinationKey' element value.
     * 
     * @param originDestinationKey
     */
    public void setOriginDestinationKey(
            OriginDestinationKey originDestinationKey) {
        this.originDestinationKey = originDestinationKey;
    }

    /** 
     * Get the 'TotalJourney' element value.
     * 
     * @return value
     */
    public TotalJourneyType getTotalJourney() {
        return totalJourney;
    }

    /** 
     * Set the 'TotalJourney' element value.
     * 
     * @param totalJourney
     */
    public void setTotalJourney(TotalJourneyType totalJourney) {
        this.totalJourney = totalJourney;
    }

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<Flight> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<Flight> list) {
        flightList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Flight origin/ destination information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SegmentKey" minOccurs="0"/>
     *       &lt;xs:element name="Indicators" minOccurs="0">
     *         &lt;!-- Reference to inner class Indicators -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Status" minOccurs="0">
     *         &lt;!-- Reference to inner class Status -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:Departure"/>
     *       &lt;xs:element ref="ns:Arrival"/>
     *       &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingCarrier"/>
     *       &lt;xs:element name="OperatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class OperatingCarrier -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:Equipment" minOccurs="0"/>
     *       &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
     *       &lt;xs:element type="ns:FlightDetailType" name="Details" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private SegmentKey segmentKey;
        private Indicators indicators;
        private Status status;
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private MarketingCarrierFlightType marketingCarrier;
        private OperatingCarrier operatingCarrier;
        private Equipment equipment;
        private CabinType cabinType;
        private FlightCOSCoreType classOfService;
        private FlightDetailType details;
        private String refs;

        /** 
         * Get the 'SegmentKey' element value.
         * 
         * @return value
         */
        public SegmentKey getSegmentKey() {
            return segmentKey;
        }

        /** 
         * Set the 'SegmentKey' element value.
         * 
         * @param segmentKey
         */
        public void setSegmentKey(SegmentKey segmentKey) {
            this.segmentKey = segmentKey;
        }

        /** 
         * Get the 'Indicators' element value.
         * 
         * @return value
         */
        public Indicators getIndicators() {
            return indicators;
        }

        /** 
         * Set the 'Indicators' element value.
         * 
         * @param indicators
         */
        public void setIndicators(Indicators indicators) {
            this.indicators = indicators;
        }

        /** 
         * Get the 'Status' element value.
         * 
         * @return value
         */
        public Status getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' element value.
         * 
         * @param status
         */
        public void setStatus(Status status) {
            this.status = status;
        }

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'MarketingCarrier' element value. Marketing Carrier information.

        Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
         * 
         * @return value
         */
        public MarketingCarrierFlightType getMarketingCarrier() {
            return marketingCarrier;
        }

        /** 
         * Set the 'MarketingCarrier' element value. Marketing Carrier information.

        Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
         * 
         * @param marketingCarrier
         */
        public void setMarketingCarrier(
                MarketingCarrierFlightType marketingCarrier) {
            this.marketingCarrier = marketingCarrier;
        }

        /** 
         * Get the 'OperatingCarrier' element value.
         * 
         * @return value
         */
        public OperatingCarrier getOperatingCarrier() {
            return operatingCarrier;
        }

        /** 
         * Set the 'OperatingCarrier' element value.
         * 
         * @param operatingCarrier
         */
        public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
            this.operatingCarrier = operatingCarrier;
        }

        /** 
         * Get the 'Equipment' element value.
         * 
         * @return value
         */
        public Equipment getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value.
         * 
         * @param equipment
         */
        public void setEquipment(Equipment equipment) {
            this.equipment = equipment;
        }

        /** 
         * Get the 'CabinType' element value.
         * 
         * @return value
         */
        public CabinType getCabinType() {
            return cabinType;
        }

        /** 
         * Set the 'CabinType' element value.
         * 
         * @param cabinType
         */
        public void setCabinType(CabinType cabinType) {
            this.cabinType = cabinType;
        }

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public FlightCOSCoreType getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(FlightCOSCoreType classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'Details' element value. Flight Details.
         * 
         * @return value
         */
        public FlightDetailType getDetails() {
            return details;
        }

        /** 
         * Set the 'Details' element value. Flight Details.
         * 
         * @param details
         */
        public void setDetails(FlightDetailType details) {
            this.details = details;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Flight-related boolean indicators.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="PricingIndicator"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ConnectionIndicator"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="E_TicketIndicator"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="TicketlessIndicator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Indicators implements Serializable
        {
            private Boolean pricingIndicator;
            private Boolean connectionIndicator;
            private Boolean ETicketIndicator;
            private Boolean ticketlessIndicator;

            /** 
             * Get the 'PricingIndicator' attribute value. When TRUE, this flight OD pair should be priced.
             * 
             * @return value
             */
            public Boolean getPricingIndicator() {
                return pricingIndicator;
            }

            /** 
             * Set the 'PricingIndicator' attribute value. When TRUE, this flight OD pair should be priced.
             * 
             * @param pricingIndicator
             */
            public void setPricingIndicator(Boolean pricingIndicator) {
                this.pricingIndicator = pricingIndicator;
            }

            /** 
             * Get the 'ConnectionIndicator' attribute value. When TRUE, there are one or more connections for this flight.
             * 
             * @return value
             */
            public Boolean getConnectionIndicator() {
                return connectionIndicator;
            }

            /** 
             * Set the 'ConnectionIndicator' attribute value. When TRUE, there are one or more connections for this flight.
             * 
             * @param connectionIndicator
             */
            public void setConnectionIndicator(Boolean connectionIndicator) {
                this.connectionIndicator = connectionIndicator;
            }

            /** 
             * Get the 'E_TicketIndicator' attribute value. When TRUE, an electronic ticket may be issued.
             * 
             * @return value
             */
            public Boolean getETicketIndicator() {
                return ETicketIndicator;
            }

            /** 
             * Set the 'E_TicketIndicator' attribute value. When TRUE, an electronic ticket may be issued.
             * 
             * @param ETicketIndicator
             */
            public void setETicketIndicator(Boolean ETicketIndicator) {
                this.ETicketIndicator = ETicketIndicator;
            }

            /** 
             * Get the 'TicketlessIndicator' attribute value. When TRUE, the fare can be purchased without issuing a ticket.
             * 
             * @return value
             */
            public Boolean getTicketlessIndicator() {
                return ticketlessIndicator;
            }

            /** 
             * Set the 'TicketlessIndicator' attribute value. When TRUE, the fare can be purchased without issuing a ticket.
             * 
             * @param ticketlessIndicator
             */
            public void setTicketlessIndicator(Boolean ticketlessIndicator) {
                this.ticketlessIndicator = ticketlessIndicator;
            }
        }
        /** 
         * Current status of the Order Item and related indicators. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CodesetType" name="StatusCode"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeOfGaugeInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ScheduleChangeInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Status implements Serializable
        {
            private CodesetType statusCode;
            private Boolean changeOfGaugeInd;
            private Boolean scheduleChangeInd;

            /** 
             * Get the 'StatusCode' element value. 
                                  Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                                
             * 
             * @return value
             */
            public CodesetType getStatusCode() {
                return statusCode;
            }

            /** 
             * Set the 'StatusCode' element value. 
                                  Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                                
             * 
             * @param statusCode
             */
            public void setStatusCode(CodesetType statusCode) {
                this.statusCode = statusCode;
            }

            /** 
             * Get the 'ChangeOfGaugeInd' attribute value. 
                                When TRUE, the order item cannot be fulfilled due to an aircraft change.
                              
             * 
             * @return value
             */
            public Boolean getChangeOfGaugeInd() {
                return changeOfGaugeInd;
            }

            /** 
             * Set the 'ChangeOfGaugeInd' attribute value. 
                                When TRUE, the order item cannot be fulfilled due to an aircraft change.
                              
             * 
             * @param changeOfGaugeInd
             */
            public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
                this.changeOfGaugeInd = changeOfGaugeInd;
            }

            /** 
             * Get the 'ScheduleChangeInd' attribute value. 
                                When TRUE, the order item cannot be fulfilled due to a flight schedule change.
                              
             * 
             * @return value
             */
            public Boolean getScheduleChangeInd() {
                return scheduleChangeInd;
            }

            /** 
             * Set the 'ScheduleChangeInd' attribute value. 
                                When TRUE, the order item cannot be fulfilled due to a flight schedule change.
                              
             * 
             * @param scheduleChangeInd
             */
            public void setScheduleChangeInd(Boolean scheduleChangeInd) {
                this.scheduleChangeInd = scheduleChangeInd;
            }
        }
        /** 
         * Operating Carrier Information.

        Operating Carrier is the carrier that operates a flight with a reference to its own prime flight number.

        Note: Operating Carrier may be different from a Marketing Carrier(s), if the flight is actually marketed by another carrier(s) within a codeshare agreement. 

        Operating Carrier may not be the AOC holder, in which case, and wherever required, this will need to be disclosed to the customer.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OperatingCarrierFlightType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OperatingCarrier extends OperatingCarrierFlightType
            implements Serializable
        {
            private DisclosureType disclosures;

            /** 
             * Get the 'Disclosures' element value.
             * 
             * @return value
             */
            public DisclosureType getDisclosures() {
                return disclosures;
            }

            /** 
             * Set the 'Disclosures' element value.
             * 
             * @param disclosures
             */
            public void setDisclosures(DisclosureType disclosures) {
                this.disclosures = disclosures;
            }
        }
    }
}
