
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Flight Price Request Message Parameters.

 Notes: Derived from MessageParamsBaseType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FltPriceReqParamsType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MessageParamsBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="ServiceFilters" minOccurs="0">
 *           &lt;!-- Reference to inner class ServiceFilters -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Pricing" minOccurs="0">
 *           &lt;!-- Reference to inner class Pricing -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FltPriceReqParamsType extends MessageParamsBaseType implements
    Serializable
{
    private ServiceFilters serviceFilters;
    private Pricing pricing;

    /** 
     * Get the 'ServiceFilters' element value.
     * 
     * @return value
     */
    public ServiceFilters getServiceFilters() {
        return serviceFilters;
    }

    /** 
     * Set the 'ServiceFilters' element value.
     * 
     * @param serviceFilters
     */
    public void setServiceFilters(ServiceFilters serviceFilters) {
        this.serviceFilters = serviceFilters;
    }

    /** 
     * Get the 'Pricing' element value.
     * 
     * @return value
     */
    public Pricing getPricing() {
        return pricing;
    }

    /** 
     * Set the 'Pricing' element value.
     * 
     * @param pricing
     */
    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }
    /** 
     * Group and subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFilters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:ServiceFilterType" name="ServiceFilter" maxOccurs="unbounded"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceFilters extends AssociatedObjectBaseType
        implements Serializable
    {
        private List<ServiceFilterType> serviceFilterList = new ArrayList<ServiceFilterType>();

        /** 
         * Get the list of 'ServiceFilter' element items. Service group and subgroup code(s).
         * 
         * @return list
         */
        public List<ServiceFilterType> getServiceFilterList() {
            return serviceFilterList;
        }

        /** 
         * Set the list of 'ServiceFilter' element items. Service group and subgroup code(s).
         * 
         * @param list
         */
        public void setServiceFilterList(List<ServiceFilterType> list) {
            serviceFilterList = list;
        }
    }
    /** 
     * Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Fee Exemption.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Pricing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="OverrideCurrency" minOccurs="0"/>
     *       &lt;xs:element name="FeeExemption" minOccurs="0">
     *         &lt;!-- Reference to inner class FeeExemption -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchangeInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardIncludedInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Pricing implements Serializable
    {
        private String overrideCurrency;
        private FeeExemption feeExemption;
        private Boolean autoExchangeInd;
        private Boolean awardIncludedInd;
        private Boolean awardOnlyInd;
        private Boolean simpleInd;

        /** 
         * Get the 'OverrideCurrency' element value. Requested override currency code for pricing.
        Example: EUR
         * 
         * @return value
         */
        public String getOverrideCurrency() {
            return overrideCurrency;
        }

        /** 
         * Set the 'OverrideCurrency' element value. Requested override currency code for pricing.
        Example: EUR
         * 
         * @param overrideCurrency
         */
        public void setOverrideCurrency(String overrideCurrency) {
            this.overrideCurrency = overrideCurrency;
        }

        /** 
         * Get the 'FeeExemption' element value.
         * 
         * @return value
         */
        public FeeExemption getFeeExemption() {
            return feeExemption;
        }

        /** 
         * Set the 'FeeExemption' element value.
         * 
         * @param feeExemption
         */
        public void setFeeExemption(FeeExemption feeExemption) {
            this.feeExemption = feeExemption;
        }

        /** 
         * Get the 'AutoExchangeInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
         * 
         * @return value
         */
        public Boolean getAutoExchangeInd() {
            return autoExchangeInd;
        }

        /** 
         * Set the 'AutoExchangeInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
         * 
         * @param autoExchangeInd
         */
        public void setAutoExchangeInd(Boolean autoExchangeInd) {
            this.autoExchangeInd = autoExchangeInd;
        }

        /** 
         * Get the 'AwardIncludedInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
         * 
         * @return value
         */
        public Boolean getAwardIncludedInd() {
            return awardIncludedInd;
        }

        /** 
         * Set the 'AwardIncludedInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
         * 
         * @param awardIncludedInd
         */
        public void setAwardIncludedInd(Boolean awardIncludedInd) {
            this.awardIncludedInd = awardIncludedInd;
        }

        /** 
         * Get the 'AwardOnlyInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
         * 
         * @return value
         */
        public Boolean getAwardOnlyInd() {
            return awardOnlyInd;
        }

        /** 
         * Set the 'AwardOnlyInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
         * 
         * @param awardOnlyInd
         */
        public void setAwardOnlyInd(Boolean awardOnlyInd) {
            this.awardOnlyInd = awardOnlyInd;
        }

        /** 
         * Get the 'SimpleInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
         * 
         * @return value
         */
        public Boolean getSimpleInd() {
            return simpleInd;
        }

        /** 
         * Set the 'SimpleInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
         * 
         * @param simpleInd
         */
        public void setSimpleInd(Boolean simpleInd) {
            this.simpleInd = simpleInd;
        }
        /** 
         * Fee exemption application for Offer pricing.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeExemption" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
         *             &lt;!-- Reference to inner class Fee -->
         *           &lt;/xs:element>
         *           &lt;xs:element ref="ns:CountryCode" minOccurs="0" maxOccurs="unbounded"/>
         *           &lt;xs:element type="xs:string" name="ProvinceCode" minOccurs="0" maxOccurs="unbounded"/>
         *           &lt;xs:element type="xs:string" name="GovernmentBody" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FeeExemption extends AssociatedObjectBaseType
            implements Serializable
        {
            private List<Fee> feeList = new ArrayList<Fee>();
            private List<CountryCodeType> countryCodeList = new ArrayList<CountryCodeType>();
            private List<String> provinceCodeList = new ArrayList<String>();
            private String governmentBody;

            /** 
             * Get the list of 'Fee' element items.
             * 
             * @return list
             */
            public List<Fee> getFeeList() {
                return feeList;
            }

            /** 
             * Set the list of 'Fee' element items.
             * 
             * @param list
             */
            public void setFeeList(List<Fee> list) {
                feeList = list;
            }

            /** 
             * Get the list of 'CountryCode' element items.
             * 
             * @return list
             */
            public List<CountryCodeType> getCountryCodeList() {
                return countryCodeList;
            }

            /** 
             * Set the list of 'CountryCode' element items.
             * 
             * @param list
             */
            public void setCountryCodeList(List<CountryCodeType> list) {
                countryCodeList = list;
            }

            /** 
             * Get the list of 'ProvinceCode' element items. Exempt province(s).
             * 
             * @return list
             */
            public List<String> getProvinceCodeList() {
                return provinceCodeList;
            }

            /** 
             * Set the list of 'ProvinceCode' element items. Exempt province(s).
             * 
             * @param list
             */
            public void setProvinceCodeList(List<String> list) {
                provinceCodeList = list;
            }

            /** 
             * Get the 'GovernmentBody' element value. Entity name.=notes=:
            1. This must be provided for certain exemptions in the Canadian market.
             * 
             * @return value
             */
            public String getGovernmentBody() {
                return governmentBody;
            }

            /** 
             * Set the 'GovernmentBody' element value. Entity name.=notes=:
            1. This must be provided for certain exemptions in the Canadian market.
             * 
             * @param governmentBody
             */
            public void setGovernmentBody(String governmentBody) {
                this.governmentBody = governmentBody;
            }
            /** 
             * Exemption(s) based on tax codes plus (optional) tax types within a tax code.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Code">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attribute type="xs:anySimpleType" use="optional" name="CollectionPoint"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="TaxType" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Fee implements Serializable
            {
                private String codeString;
                private String codeCollectionPoint;
                private List<String> taxTypeList = new ArrayList<String>();
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getCodeString() {
                    return codeString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param codeString
                 */
                public void setCodeString(String codeString) {
                    this.codeString = codeString;
                }

                /** 
                 * Get the 'CollectionPoint' attribute value. Airport code location for exempt ZP or XF taxes.
                Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.

                http://www.iata.org/publications/Pages/code-search.aspx
                 * 
                 * @return value
                 */
                public String getCodeCollectionPoint() {
                    return codeCollectionPoint;
                }

                /** 
                 * Set the 'CollectionPoint' attribute value. Airport code location for exempt ZP or XF taxes.
                Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.

                http://www.iata.org/publications/Pages/code-search.aspx
                 * 
                 * @param codeCollectionPoint
                 */
                public void setCodeCollectionPoint(String codeCollectionPoint) {
                    this.codeCollectionPoint = codeCollectionPoint;
                }

                /** 
                 * Get the list of 'TaxType' element items. Tax type(s) within the tax code. Examples: I, C
                 * 
                 * @return list
                 */
                public List<String> getTaxTypeList() {
                    return taxTypeList;
                }

                /** 
                 * Set the list of 'TaxType' element items. Tax type(s) within the tax code. Examples: I, C
                 * 
                 * @param list
                 */
                public void setTaxTypeList(List<String> list) {
                    taxTypeList = list;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
    }
}
