
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Inventory Guarantee Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvGuaranteeNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:attribute type="xs:boolean" use="optional" name="GuaranteeRequestInd"/>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Results">
 *           &lt;!-- Reference to inner class Results -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InvGuaranteeNoticeType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int QUERY_CHOICE = 0;
    private static final int RESULTS_CHOICE = 1;
    private Boolean query;
    private Results results;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the 'GuaranteeRequestInd' attribute value. 
                      When TRUE, inventory guarantee is requested for offers.
                    
     * 
     * @return value
     */
    public Boolean getQuery() {
        return query;
    }

    /** 
     * Set the 'GuaranteeRequestInd' attribute value. 
                      When TRUE, inventory guarantee is requested for offers.
                    
     * 
     * @param query
     */
    public void setQuery(Boolean query) {
        setChoiceSelect(QUERY_CHOICE);
        this.query = query;
    }

    /** 
     * Check if Results is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResults() {
        return choiceSelect == RESULTS_CHOICE;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        setChoiceSelect(RESULTS_CHOICE);
        this.results = results;
    }
    /** 
     * 
                  Inventory Guaranteed during transaction processing.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="InventoryGuarantee" minOccurs="0">
     *         &lt;!-- Reference to inner class InventoryGuarantee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoGuaranteeInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private InventoryGuarantee inventoryGuarantee;
        private Boolean noGuaranteeInd;

        /** 
         * Get the 'InventoryGuarantee' element value.
         * 
         * @return value
         */
        public InventoryGuarantee getInventoryGuarantee() {
            return inventoryGuarantee;
        }

        /** 
         * Set the 'InventoryGuarantee' element value.
         * 
         * @param inventoryGuarantee
         */
        public void setInventoryGuarantee(InventoryGuarantee inventoryGuarantee) {
            this.inventoryGuarantee = inventoryGuarantee;
        }

        /** 
         * Get the 'NoGuaranteeInd' attribute value. When TRUE, no offers have guaranteed inventory .
         * 
         * @return value
         */
        public Boolean getNoGuaranteeInd() {
            return noGuaranteeInd;
        }

        /** 
         * Set the 'NoGuaranteeInd' attribute value. When TRUE, no offers have guaranteed inventory .
         * 
         * @param noGuaranteeInd
         */
        public void setNoGuaranteeInd(Boolean noGuaranteeInd) {
            this.noGuaranteeInd = noGuaranteeInd;
        }
        /** 
         * Inventory Guarantee 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvGuaranteeID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:InvGuaranteeTimeLimits"/>
         *       &lt;xs:element type="ns:MultiAssociationType" name="Associations" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InventoryGuarantee implements Serializable
        {
            private String invGuaranteeID;
            private CoreDateGrpType invGuaranteeTimeLimits;
            private MultiAssociationType associations;

            /** 
             * Get the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @return value
             */
            public String getInvGuaranteeID() {
                return invGuaranteeID;
            }

            /** 
             * Set the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @param invGuaranteeID
             */
            public void setInvGuaranteeID(String invGuaranteeID) {
                this.invGuaranteeID = invGuaranteeID;
            }

            /** 
             * Get the 'InvGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInvGuaranteeTimeLimits() {
                return invGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InvGuaranteeTimeLimits' element value.
             * 
             * @param invGuaranteeTimeLimits
             */
            public void setInvGuaranteeTimeLimits(
                    CoreDateGrpType invGuaranteeTimeLimits) {
                this.invGuaranteeTimeLimits = invGuaranteeTimeLimits;
            }

            /** 
             * Get the 'Associations' element value. 
                                  Inventory Guarantee Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                                
             * 
             * @return value
             */
            public MultiAssociationType getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. 
                                  Inventory Guarantee Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                                
             * 
             * @param associations
             */
            public void setAssociations(MultiAssociationType associations) {
                this.associations = associations;
            }
        }
    }
}
