
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 *  Alerts definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopAlertsType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:PinPhraseQuestionType" name="PIN_AuthRequest" minOccurs="0"/>
 *         &lt;xs:element name="OrderItemExceptions" minOccurs="0">
 *           &lt;!-- Reference to inner class OrderItemExceptions -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItinReshopAlertsType extends AssociatedObjectBaseType implements
    Serializable
{
    private PinPhraseQuestionType PINAuthRequest;
    private OrderItemExceptions orderItemExceptions;

    /** 
     * Get the 'PIN_AuthRequest' element value. Traveler PIN Phrase Authentication Request.

    Notes:
    1. This processing condition has occured because additional Traveler authentication is required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme request information, e.g. the Pin Phrase Challenge Question/ Prompt information.
     * 
     * @return value
     */
    public PinPhraseQuestionType getPINAuthRequest() {
        return PINAuthRequest;
    }

    /** 
     * Set the 'PIN_AuthRequest' element value. Traveler PIN Phrase Authentication Request.

    Notes:
    1. This processing condition has occured because additional Traveler authentication is required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme request information, e.g. the Pin Phrase Challenge Question/ Prompt information.
     * 
     * @param PINAuthRequest
     */
    public void setPINAuthRequest(PinPhraseQuestionType PINAuthRequest) {
        this.PINAuthRequest = PINAuthRequest;
    }

    /** 
     * Get the 'OrderItemExceptions' element value.
     * 
     * @return value
     */
    public OrderItemExceptions getOrderItemExceptions() {
        return orderItemExceptions;
    }

    /** 
     * Set the 'OrderItemExceptions' element value.
     * 
     * @param orderItemExceptions
     */
    public void setOrderItemExceptions(OrderItemExceptions orderItemExceptions) {
        this.orderItemExceptions = orderItemExceptions;
    }
    /** 
     * Order Item Creation or Amendment Failure Alert.

    Supports notification of order item creation, deletion or amendment  failures, including the reasons for failure.

    passenger not eligible, product compatibility broken, etc. 

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemExceptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Exception" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class _Exception -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItemExceptions implements Serializable
    {
        private List<_Exception> exceptionList = new ArrayList<_Exception>();

        /** 
         * Get the list of 'Exception' element items.
         * 
         * @return list
         */
        public List<_Exception> getExceptionList() {
            return exceptionList;
        }

        /** 
         * Set the list of 'Exception' element items.
         * 
         * @param list
         */
        public void setExceptionList(List<_Exception> list) {
            exceptionList = list;
        }
        /** 
         * Exception detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Exception" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OrderItemID"/>
         *       &lt;xs:element type="ns:CodesetType" name="Code" minOccurs="0"/>
         *       &lt;xs:element name="ExpiredTimeLimits" minOccurs="0">
         *         &lt;!-- Reference to inner class ExpiredTimeLimits -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="InvDiscrepency" minOccurs="0">
         *         &lt;!-- Reference to inner class InvDiscrepency -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PriceVariances" minOccurs="0">
         *         &lt;!-- Reference to inner class PriceVariances -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Eligibility" minOccurs="0">
         *         &lt;!-- Reference to inner class Eligibility -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class _Exception implements Serializable
        {
            private OrderItemID orderItemID;
            private CodesetType code;
            private ExpiredTimeLimits expiredTimeLimits;
            private InvDiscrepency invDiscrepency;
            private PriceVariances priceVariances;
            private Eligibility eligibility;

            /** 
             * Get the 'OrderItemID' element value. Associated Order Item ID(s).
            Example: ORD7333-001
             * 
             * @return value
             */
            public OrderItemID getOrderItemID() {
                return orderItemID;
            }

            /** 
             * Set the 'OrderItemID' element value. Associated Order Item ID(s).
            Example: ORD7333-001
             * 
             * @param orderItemID
             */
            public void setOrderItemID(OrderItemID orderItemID) {
                this.orderItemID = orderItemID;
            }

            /** 
             * Get the 'Code' element value. Offer Item Inventory Status Code.

            Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
             * 
             * @return value
             */
            public CodesetType getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value. Offer Item Inventory Status Code.

            Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
             * 
             * @param code
             */
            public void setCode(CodesetType code) {
                this.code = code;
            }

            /** 
             * Get the 'ExpiredTimeLimits' element value.
             * 
             * @return value
             */
            public ExpiredTimeLimits getExpiredTimeLimits() {
                return expiredTimeLimits;
            }

            /** 
             * Set the 'ExpiredTimeLimits' element value.
             * 
             * @param expiredTimeLimits
             */
            public void setExpiredTimeLimits(ExpiredTimeLimits expiredTimeLimits) {
                this.expiredTimeLimits = expiredTimeLimits;
            }

            /** 
             * Get the 'InvDiscrepency' element value.
             * 
             * @return value
             */
            public InvDiscrepency getInvDiscrepency() {
                return invDiscrepency;
            }

            /** 
             * Set the 'InvDiscrepency' element value.
             * 
             * @param invDiscrepency
             */
            public void setInvDiscrepency(InvDiscrepency invDiscrepency) {
                this.invDiscrepency = invDiscrepency;
            }

            /** 
             * Get the 'PriceVariances' element value.
             * 
             * @return value
             */
            public PriceVariances getPriceVariances() {
                return priceVariances;
            }

            /** 
             * Set the 'PriceVariances' element value.
             * 
             * @param priceVariances
             */
            public void setPriceVariances(PriceVariances priceVariances) {
                this.priceVariances = priceVariances;
            }

            /** 
             * Get the 'Eligibility' element value.
             * 
             * @return value
             */
            public Eligibility getEligibility() {
                return eligibility;
            }

            /** 
             * Set the 'Eligibility' element value.
             * 
             * @param eligibility
             */
            public void setEligibility(Eligibility eligibility) {
                this.eligibility = eligibility;
            }
            /** 
             * Expired Time Limit(s).

            Supports notification of expired time limits in shopping, order management and payment/ ticketing response messages. Alternate Offers, if available, may be included in the AlternateOffers node.

            Supported time limits include Bilateral, Deposit, Inventory Guarantee, Naming, Offer, Payment, Price Guarantee
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExpiredTimeLimits" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ExpiredTimeLimit" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ExpiredTimeLimit -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AltOfferInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ExpiredTimeLimits implements Serializable
            {
                private List<ExpiredTimeLimit> expiredTimeLimitList = new ArrayList<ExpiredTimeLimit>();
                private Boolean altOfferInd;

                /** 
                 * Get the list of 'ExpiredTimeLimit' element items.
                 * 
                 * @return list
                 */
                public List<ExpiredTimeLimit> getExpiredTimeLimitList() {
                    return expiredTimeLimitList;
                }

                /** 
                 * Set the list of 'ExpiredTimeLimit' element items.
                 * 
                 * @param list
                 */
                public void setExpiredTimeLimitList(List<ExpiredTimeLimit> list) {
                    expiredTimeLimitList = list;
                }

                /** 
                 * Get the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @return value
                 */
                public Boolean getAltOfferInd() {
                    return altOfferInd;
                }

                /** 
                 * Set the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @param altOfferInd
                 */
                public void setAltOfferInd(Boolean altOfferInd) {
                    this.altOfferInd = altOfferInd;
                }
                /** 
                 * Expired Time Limit(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExpiredTimeLimit" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Type"/>
                 *       &lt;xs:element type="xs:date" name="ExpiredDate" minOccurs="0"/>
                 *       &lt;xs:element name="Associations" minOccurs="0">
                 *         &lt;!-- Reference to inner class Associations -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="AlternateOffers" minOccurs="0">
                 *         &lt;!-- Reference to inner class AlternateOffers -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="references"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ExpiredTimeLimit implements Serializable
                {
                    private String type;
                    private Date expiredDate;
                    private Associations associations;
                    private AlternateOffers alternateOffers;
                    private String references;
                    private String trxItemKey;

                    /** 
                     * Get the 'Type' element value. Time Limit Type.
                    Examples: Bilateral, Deposit, InventoryGuarantee, Naming, Offer, Payment, PriceGuarantee
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' element value. Time Limit Type.
                    Examples: Bilateral, Deposit, InventoryGuarantee, Naming, Offer, Payment, PriceGuarantee
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ExpiredDate' element value. Expired Date Value. Example: 2015-01-13T13:59:38Z
                     * 
                     * @return value
                     */
                    public Date getExpiredDate() {
                        return expiredDate;
                    }

                    /** 
                     * Set the 'ExpiredDate' element value. Expired Date Value. Example: 2015-01-13T13:59:38Z
                     * 
                     * @param expiredDate
                     */
                    public void setExpiredDate(Date expiredDate) {
                        this.expiredDate = expiredDate;
                    }

                    /** 
                     * Get the 'Associations' element value.
                     * 
                     * @return value
                     */
                    public Associations getAssociations() {
                        return associations;
                    }

                    /** 
                     * Set the 'Associations' element value.
                     * 
                     * @param associations
                     */
                    public void setAssociations(Associations associations) {
                        this.associations = associations;
                    }

                    /** 
                     * Get the 'AlternateOffers' element value.
                     * 
                     * @return value
                     */
                    public AlternateOffers getAlternateOffers() {
                        return alternateOffers;
                    }

                    /** 
                     * Set the 'AlternateOffers' element value.
                     * 
                     * @param alternateOffers
                     */
                    public void setAlternateOffers(
                            AlternateOffers alternateOffers) {
                        this.alternateOffers = alternateOffers;
                    }

                    /** 
                     * Get the 'references' attribute value. Object association(s) between this object and any object instance(s).
                     * 
                     * @return value
                     */
                    public String getReferences() {
                        return references;
                    }

                    /** 
                     * Set the 'references' attribute value. Object association(s) between this object and any object instance(s).
                     * 
                     * @param references
                     */
                    public void setReferences(String references) {
                        this.references = references;
                    }

                    /** 
                     * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
                     * 
                     * @return value
                     */
                    public String getTrxItemKey() {
                        return trxItemKey;
                    }

                    /** 
                     * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
                     * 
                     * @param trxItemKey
                     */
                    public void setTrxItemKey(String trxItemKey) {
                        this.trxItemKey = trxItemKey;
                    }
                    /** 
                     * Association(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Passengers" minOccurs="0">
                     *         &lt;!-- Reference to inner class Passengers -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class OtherAssociation -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Associations implements Serializable
                    {
                        private Passengers passengers;
                        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                        /** 
                         * Get the 'Passengers' element value.
                         * 
                         * @return value
                         */
                        public Passengers getPassengers() {
                            return passengers;
                        }

                        /** 
                         * Set the 'Passengers' element value.
                         * 
                         * @param passengers
                         */
                        public void setPassengers(Passengers passengers) {
                            this.passengers = passengers;
                        }

                        /** 
                         * Get the list of 'OtherAssociation' element items.
                         * 
                         * @return list
                         */
                        public List<OtherAssociation> getOtherAssociationList() {
                            return otherAssociationList;
                        }

                        /** 
                         * Set the list of 'OtherAssociation' element items.
                         * 
                         * @param list
                         */
                        public void setOtherAssociationList(
                                List<OtherAssociation> list) {
                            otherAssociationList = list;
                        }
                        /** 
                         * Passenger(s)/ Groups associated with the Offer Item.

                        Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:choice>
                         *       &lt;xs:element ref="ns:PassengerReferences"/>
                         *       &lt;xs:element ref="ns:GroupReference"/>
                         *     &lt;/xs:choice>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Passengers implements Serializable
                        {
                            private int passengersSelect = -1;
                            private static final int PASSENGER_REFERENCES_CHOICE = 0;
                            private static final int GROUP_REFERENCE_CHOICE = 1;
                            private PassengerReferences passengerReferences;
                            private GroupReference groupReference;

                            private void setPassengersSelect(int choice) {
                                if (passengersSelect == -1) {
                                    passengersSelect = choice;
                                } else if (passengersSelect != choice) {
                                    throw new IllegalStateException(
                                            "Need to call clearPassengersSelect() before changing existing choice");
                                }
                            }

                            /** 
                             * Clear the choice selection.
                             */
                            public void clearPassengersSelect() {
                                passengersSelect = -1;
                            }

                            /** 
                             * Check if PassengerReferences is current selection for choice.
                             * 
                             * @return <code>true</code> if selection, <code>false</code> if not
                             */
                            public boolean ifPassengerReferences() {
                                return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                            }

                            /** 
                             * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                             * 
                             * @return value
                             */
                            public PassengerReferences getPassengerReferences() {
                                return passengerReferences;
                            }

                            /** 
                             * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                             * 
                             * @param passengerReferences
                             */
                            public void setPassengerReferences(
                                    PassengerReferences passengerReferences) {
                                setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                                this.passengerReferences = passengerReferences;
                            }

                            /** 
                             * Check if GroupReference is current selection for choice.
                             * 
                             * @return <code>true</code> if selection, <code>false</code> if not
                             */
                            public boolean ifGroupReference() {
                                return passengersSelect == GROUP_REFERENCE_CHOICE;
                            }

                            /** 
                             * Get the 'GroupReference' element value.
                             * 
                             * @return value
                             */
                            public GroupReference getGroupReference() {
                                return groupReference;
                            }

                            /** 
                             * Set the 'GroupReference' element value.
                             * 
                             * @param groupReference
                             */
                            public void setGroupReference(
                                    GroupReference groupReference) {
                                setPassengersSelect(GROUP_REFERENCE_CHOICE);
                                this.groupReference = groupReference;
                            }
                        }
                        /** 
                         * Other Named Association(s).

                        Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OtherAssociation implements
                            Serializable
                        {
                            private String type;
                            private String referenceValue;

                            /** 
                             * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'ReferenceValue' attribute value. Associated object instance value.
                            Example: mediaGroup1
                             * 
                             * @return value
                             */
                            public String getReferenceValue() {
                                return referenceValue;
                            }

                            /** 
                             * Set the 'ReferenceValue' attribute value. Associated object instance value.
                            Example: mediaGroup1
                             * 
                             * @param referenceValue
                             */
                            public void setReferenceValue(String referenceValue) {
                                this.referenceValue = referenceValue;
                            }
                        }
                    }
                    /** 
                     * Alternate Offer(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="TotalOfferQuantity" minOccurs="0"/>
                     *       &lt;xs:element type="ns:AirlineID_Type" name="Owner"/>
                     *       &lt;xs:element name="AlternateOffer" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class AlternateOffer -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AlternateOffers implements Serializable
                    {
                        private String totalOfferQuantity;
                        private AirlineIDType owner;
                        private List<AlternateOffer> alternateOfferList = new ArrayList<AlternateOffer>();

                        /** 
                         * Get the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                         * 
                         * @return value
                         */
                        public String getTotalOfferQuantity() {
                            return totalOfferQuantity;
                        }

                        /** 
                         * Set the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                         * 
                         * @param totalOfferQuantity
                         */
                        public void setTotalOfferQuantity(
                                String totalOfferQuantity) {
                            this.totalOfferQuantity = totalOfferQuantity;
                        }

                        /** 
                         * Get the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                         * 
                         * @return value
                         */
                        public AirlineIDType getOwner() {
                            return owner;
                        }

                        /** 
                         * Set the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                         * 
                         * @param owner
                         */
                        public void setOwner(AirlineIDType owner) {
                            this.owner = owner;
                        }

                        /** 
                         * Get the list of 'AlternateOffer' element items.
                         * 
                         * @return list
                         */
                        public List<AlternateOffer> getAlternateOfferList() {
                            return alternateOfferList;
                        }

                        /** 
                         * Set the list of 'AlternateOffer' element items.
                         * 
                         * @param list
                         */
                        public void setAlternateOfferList(
                                List<AlternateOffer> list) {
                            alternateOfferList = list;
                        }
                        /** 
                         * Airline Alternate Offer Detail.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffer" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:complexContent>
                         *       &lt;xs:extension base="ns:OfferItemDetailType">
                         *         &lt;xs:sequence>
                         *           &lt;xs:element ref="ns:AltBaggageOffer" minOccurs="0"/>
                         *           &lt;xs:element ref="ns:AltPricedFlightOffer" minOccurs="0"/>
                         *           &lt;xs:element ref="ns:AltOtherOffer" minOccurs="0"/>
                         *           &lt;xs:element ref="ns:AltSeatOffer" minOccurs="0"/>
                         *         &lt;/xs:sequence>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:complexContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AlternateOffer
                                extends
                                    OfferItemDetailType implements Serializable
                        {
                            private AltBaggageOfferType altBaggageOffer;
                            private AltPricedFlightOfferType altPricedFlightOffer;
                            private AltOtherOfferType altOtherOffer;
                            private AltSeatOfferType altSeatOffer;

                            /** 
                             * Get the 'AltBaggageOffer' element value.
                             * 
                             * @return value
                             */
                            public AltBaggageOfferType getAltBaggageOffer() {
                                return altBaggageOffer;
                            }

                            /** 
                             * Set the 'AltBaggageOffer' element value.
                             * 
                             * @param altBaggageOffer
                             */
                            public void setAltBaggageOffer(
                                    AltBaggageOfferType altBaggageOffer) {
                                this.altBaggageOffer = altBaggageOffer;
                            }

                            /** 
                             * Get the 'AltPricedFlightOffer' element value.
                             * 
                             * @return value
                             */
                            public AltPricedFlightOfferType getAltPricedFlightOffer() {
                                return altPricedFlightOffer;
                            }

                            /** 
                             * Set the 'AltPricedFlightOffer' element value.
                             * 
                             * @param altPricedFlightOffer
                             */
                            public void setAltPricedFlightOffer(
                                    AltPricedFlightOfferType altPricedFlightOffer) {
                                this.altPricedFlightOffer = altPricedFlightOffer;
                            }

                            /** 
                             * Get the 'AltOtherOffer' element value.
                             * 
                             * @return value
                             */
                            public AltOtherOfferType getAltOtherOffer() {
                                return altOtherOffer;
                            }

                            /** 
                             * Set the 'AltOtherOffer' element value.
                             * 
                             * @param altOtherOffer
                             */
                            public void setAltOtherOffer(
                                    AltOtherOfferType altOtherOffer) {
                                this.altOtherOffer = altOtherOffer;
                            }

                            /** 
                             * Get the 'AltSeatOffer' element value.
                             * 
                             * @return value
                             */
                            public AltSeatOfferType getAltSeatOffer() {
                                return altSeatOffer;
                            }

                            /** 
                             * Set the 'AltSeatOffer' element value.
                             * 
                             * @param altSeatOffer
                             */
                            public void setAltSeatOffer(
                                    AltSeatOfferType altSeatOffer) {
                                this.altSeatOffer = altSeatOffer;
                            }
                        }
                    }
                }
            }
            /** 
             * Inventory Discrepency(s).

            Supports notifying seller systems of discrepency(s) between offered inventory (from a prior shopping response) and available inventory during order processing. If included in a response message, it may also include alternate offers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvDiscrepency" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Associations" minOccurs="0">
             *         &lt;!-- Reference to inner class Associations -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AlternateOffers" minOccurs="0">
             *         &lt;!-- Reference to inner class AlternateOffers -->
             *       &lt;/xs:element>
             *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="policy"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="References"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="objectMetaReferences"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="objectKey"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AltOfferInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoInventoryInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class InvDiscrepency implements Serializable
            {
                private Associations associations;
                private AlternateOffers alternateOffers;
                private Remarks remarks;
                private String policy;
                private String references;
                private String objectMetaReferences;
                private String objectKey;
                private Boolean altOfferInd;
                private Boolean noInventoryInd;

                /** 
                 * Get the 'Associations' element value.
                 * 
                 * @return value
                 */
                public Associations getAssociations() {
                    return associations;
                }

                /** 
                 * Set the 'Associations' element value.
                 * 
                 * @param associations
                 */
                public void setAssociations(Associations associations) {
                    this.associations = associations;
                }

                /** 
                 * Get the 'AlternateOffers' element value.
                 * 
                 * @return value
                 */
                public AlternateOffers getAlternateOffers() {
                    return alternateOffers;
                }

                /** 
                 * Set the 'AlternateOffers' element value.
                 * 
                 * @param alternateOffers
                 */
                public void setAlternateOffers(AlternateOffers alternateOffers) {
                    this.alternateOffers = alternateOffers;
                }

                /** 
                 * Get the 'Remarks' element value.
                 * 
                 * @return value
                 */
                public Remarks getRemarks() {
                    return remarks;
                }

                /** 
                 * Set the 'Remarks' element value.
                 * 
                 * @param remarks
                 */
                public void setRemarks(Remarks remarks) {
                    this.remarks = remarks;
                }

                /** 
                 * Get the 'policy' attribute value. Associated Policy Reference(s). Example: pol1

                Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.This provides a method to indicate that the data in this element alone, or in combination with other elements, may be subject to an information management policy. As such, this attribute may contain a code to indicate that a message element contains sensitive data and may be subject to bilaterally agreed upon policies, etc.
                 * 
                 * @return value
                 */
                public String getPolicy() {
                    return policy;
                }

                /** 
                 * Set the 'policy' attribute value. Associated Policy Reference(s). Example: pol1

                Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.This provides a method to indicate that the data in this element alone, or in combination with other elements, may be subject to an information management policy. As such, this attribute may contain a code to indicate that a message element contains sensitive data and may be subject to bilaterally agreed upon policies, etc.
                 * 
                 * @param policy
                 */
                public void setPolicy(String policy) {
                    this.policy = policy;
                }

                /** 
                 * Get the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getReferences() {
                    return references;
                }

                /** 
                 * Set the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param references
                 */
                public void setReferences(String references) {
                    this.references = references;
                }

                /** 
                 * Get the 'objectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
                 * 
                 * @return value
                 */
                public String getObjectMetaReferences() {
                    return objectMetaReferences;
                }

                /** 
                 * Set the 'objectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
                 * 
                 * @param objectMetaReferences
                 */
                public void setObjectMetaReferences(String objectMetaReferences) {
                    this.objectMetaReferences = objectMetaReferences;
                }

                /** 
                 * Get the 'objectKey' attribute value. Object globally unique Instance ID. Example: obj1
                 * 
                 * @return value
                 */
                public String getObjectKey() {
                    return objectKey;
                }

                /** 
                 * Set the 'objectKey' attribute value. Object globally unique Instance ID. Example: obj1
                 * 
                 * @param objectKey
                 */
                public void setObjectKey(String objectKey) {
                    this.objectKey = objectKey;
                }

                /** 
                 * Get the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @return value
                 */
                public Boolean getAltOfferInd() {
                    return altOfferInd;
                }

                /** 
                 * Set the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @param altOfferInd
                 */
                public void setAltOfferInd(Boolean altOfferInd) {
                    this.altOfferInd = altOfferInd;
                }

                /** 
                 * Get the 'NoInventoryInd' attribute value. When TRUE, the inventory for the requested Offer Item is not available to order.
                 * 
                 * @return value
                 */
                public Boolean getNoInventoryInd() {
                    return noInventoryInd;
                }

                /** 
                 * Set the 'NoInventoryInd' attribute value. When TRUE, the inventory for the requested Offer Item is not available to order.
                 * 
                 * @param noInventoryInd
                 */
                public void setNoInventoryInd(Boolean noInventoryInd) {
                    this.noInventoryInd = noInventoryInd;
                }
                /** 
                 * Association(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Passengers" minOccurs="0">
                 *         &lt;!-- Reference to inner class Passengers -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherAssociation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Associations implements Serializable
                {
                    private Passengers passengers;
                    private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }

                    /** 
                     * Get the list of 'OtherAssociation' element items.
                     * 
                     * @return list
                     */
                    public List<OtherAssociation> getOtherAssociationList() {
                        return otherAssociationList;
                    }

                    /** 
                     * Set the list of 'OtherAssociation' element items.
                     * 
                     * @param list
                     */
                    public void setOtherAssociationList(
                            List<OtherAssociation> list) {
                        otherAssociationList = list;
                    }
                    /** 
                     * Passenger(s)/ Groups associated with the Offer Item.

                    Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                    /** 
                     * Other Named Association(s).

                    Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherAssociation implements
                        Serializable
                    {
                        private String type;
                        private String referenceValue;

                        /** 
                         * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'ReferenceValue' attribute value. Associated object instance value.
                        Example: mediaGroup1
                         * 
                         * @return value
                         */
                        public String getReferenceValue() {
                            return referenceValue;
                        }

                        /** 
                         * Set the 'ReferenceValue' attribute value. Associated object instance value.
                        Example: mediaGroup1
                         * 
                         * @param referenceValue
                         */
                        public void setReferenceValue(String referenceValue) {
                            this.referenceValue = referenceValue;
                        }
                    }
                }
                /** 
                 * Alternate Offer(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="TotalOfferQuantity" minOccurs="0"/>
                 *       &lt;xs:element type="ns:AirlineID_Type" name="Owner"/>
                 *       &lt;xs:element name="AlternateOffer" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class AlternateOffer -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AlternateOffers implements Serializable
                {
                    private String totalOfferQuantity;
                    private AirlineIDType owner;
                    private List<AlternateOffer> alternateOfferList = new ArrayList<AlternateOffer>();

                    /** 
                     * Get the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                     * 
                     * @return value
                     */
                    public String getTotalOfferQuantity() {
                        return totalOfferQuantity;
                    }

                    /** 
                     * Set the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                     * 
                     * @param totalOfferQuantity
                     */
                    public void setTotalOfferQuantity(String totalOfferQuantity) {
                        this.totalOfferQuantity = totalOfferQuantity;
                    }

                    /** 
                     * Get the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @return value
                     */
                    public AirlineIDType getOwner() {
                        return owner;
                    }

                    /** 
                     * Set the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @param owner
                     */
                    public void setOwner(AirlineIDType owner) {
                        this.owner = owner;
                    }

                    /** 
                     * Get the list of 'AlternateOffer' element items.
                     * 
                     * @return list
                     */
                    public List<AlternateOffer> getAlternateOfferList() {
                        return alternateOfferList;
                    }

                    /** 
                     * Set the list of 'AlternateOffer' element items.
                     * 
                     * @param list
                     */
                    public void setAlternateOfferList(List<AlternateOffer> list) {
                        alternateOfferList = list;
                    }
                    /** 
                     * Airline Alternate Offer Detail.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffer" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:complexContent>
                     *       &lt;xs:extension base="ns:OfferItemDetailType">
                     *         &lt;xs:sequence>
                     *           &lt;xs:element ref="ns:AltBaggageOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltPricedFlightOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltOtherOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltSeatOffer" minOccurs="0"/>
                     *         &lt;/xs:sequence>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:complexContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AlternateOffer
                            extends
                                OfferItemDetailType implements Serializable
                    {
                        private AltBaggageOfferType altBaggageOffer;
                        private AltPricedFlightOfferType altPricedFlightOffer;
                        private AltOtherOfferType altOtherOffer;
                        private AltSeatOfferType altSeatOffer;

                        /** 
                         * Get the 'AltBaggageOffer' element value.
                         * 
                         * @return value
                         */
                        public AltBaggageOfferType getAltBaggageOffer() {
                            return altBaggageOffer;
                        }

                        /** 
                         * Set the 'AltBaggageOffer' element value.
                         * 
                         * @param altBaggageOffer
                         */
                        public void setAltBaggageOffer(
                                AltBaggageOfferType altBaggageOffer) {
                            this.altBaggageOffer = altBaggageOffer;
                        }

                        /** 
                         * Get the 'AltPricedFlightOffer' element value.
                         * 
                         * @return value
                         */
                        public AltPricedFlightOfferType getAltPricedFlightOffer() {
                            return altPricedFlightOffer;
                        }

                        /** 
                         * Set the 'AltPricedFlightOffer' element value.
                         * 
                         * @param altPricedFlightOffer
                         */
                        public void setAltPricedFlightOffer(
                                AltPricedFlightOfferType altPricedFlightOffer) {
                            this.altPricedFlightOffer = altPricedFlightOffer;
                        }

                        /** 
                         * Get the 'AltOtherOffer' element value.
                         * 
                         * @return value
                         */
                        public AltOtherOfferType getAltOtherOffer() {
                            return altOtherOffer;
                        }

                        /** 
                         * Set the 'AltOtherOffer' element value.
                         * 
                         * @param altOtherOffer
                         */
                        public void setAltOtherOffer(
                                AltOtherOfferType altOtherOffer) {
                            this.altOtherOffer = altOtherOffer;
                        }

                        /** 
                         * Get the 'AltSeatOffer' element value.
                         * 
                         * @return value
                         */
                        public AltSeatOfferType getAltSeatOffer() {
                            return altSeatOffer;
                        }

                        /** 
                         * Set the 'AltSeatOffer' element value.
                         * 
                         * @param altSeatOffer
                         */
                        public void setAltSeatOffer(
                                AltSeatOfferType altSeatOffer) {
                            this.altSeatOffer = altSeatOffer;
                        }
                    }
                }
            }
            /** 
             * Price Variance Rule(s) Exceptions.

            Note: Supports specifying the acceptable amount and/or percentage of the total amount by which the Order item price can vary from the Offer price for Order creation to proceed, for example to cover minor currency exchange rate fluctuations for taxes quoted in a different currency. 
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVariances" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PriceVariance -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="RuleExceptionInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriceVariances implements Serializable
            {
                private List<PriceVariance> priceVarianceList = new ArrayList<PriceVariance>();
                private Boolean ruleExceptionInd;

                /** 
                 * Get the list of 'PriceVariance' element items.
                 * 
                 * @return list
                 */
                public List<PriceVariance> getPriceVarianceList() {
                    return priceVarianceList;
                }

                /** 
                 * Set the list of 'PriceVariance' element items.
                 * 
                 * @param list
                 */
                public void setPriceVarianceList(List<PriceVariance> list) {
                    priceVarianceList = list;
                }

                /** 
                 * Get the 'RuleExceptionInd' attribute value. When TRUE, a pricing variant rule could not be applied.
                 * 
                 * @return value
                 */
                public Boolean getRuleExceptionInd() {
                    return ruleExceptionInd;
                }

                /** 
                 * Set the 'RuleExceptionInd' attribute value. When TRUE, a pricing variant rule could not be applied.
                 * 
                 * @param ruleExceptionInd
                 */
                public void setRuleExceptionInd(Boolean ruleExceptionInd) {
                    this.ruleExceptionInd = ruleExceptionInd;
                }
                /** 
                 * Price Variance Rule(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RuleID" minOccurs="0">
                 *         &lt;!-- Reference to inner class RuleID -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Associations" minOccurs="0">
                 *         &lt;!-- Reference to inner class Associations -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PriceVariance implements Serializable
                {
                    private RuleID ruleID;
                    private Amount amount;
                    private Associations associations;
                    private String trxItemKey;

                    /** 
                     * Get the 'RuleID' element value.
                     * 
                     * @return value
                     */
                    public RuleID getRuleID() {
                        return ruleID;
                    }

                    /** 
                     * Set the 'RuleID' element value.
                     * 
                     * @param ruleID
                     */
                    public void setRuleID(RuleID ruleID) {
                        this.ruleID = ruleID;
                    }

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Associations' element value.
                     * 
                     * @return value
                     */
                    public Associations getAssociations() {
                        return associations;
                    }

                    /** 
                     * Set the 'Associations' element value.
                     * 
                     * @param associations
                     */
                    public void setAssociations(Associations associations) {
                        this.associations = associations;
                    }

                    /** 
                     * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
                     * 
                     * @return value
                     */
                    public String getTrxItemKey() {
                        return trxItemKey;
                    }

                    /** 
                     * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
                     * 
                     * @param trxItemKey
                     */
                    public void setTrxItemKey(String trxItemKey) {
                        this.trxItemKey = trxItemKey;
                    }
                    /** 
                     * Rule ID.
                    Example: PRICERULE001
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
                     *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RuleID implements Serializable
                    {
                        private String string;
                        private String context;
                        private String name;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Context' attribute value. Rule ID Context.
                         * 
                         * @return value
                         */
                        public String getContext() {
                            return context;
                        }

                        /** 
                         * Set the 'Context' attribute value. Rule ID Context.
                         * 
                         * @param context
                         */
                        public void setContext(String context) {
                            this.context = context;
                        }

                        /** 
                         * Get the 'Name' attribute value. Rule Name.
                        Example: Acceptable Order Item Price Variance
                         * 
                         * @return value
                         */
                        public String getName() {
                            return name;
                        }

                        /** 
                         * Set the 'Name' attribute value. Rule Name.
                        Example: Acceptable Order Item Price Variance
                         * 
                         * @param name
                         */
                        public void setName(String name) {
                            this.name = name;
                        }
                    }
                    /** 
                     * Price Variance Amount and/or Percentage.
                    Example: 20 USD, 2 Percent
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:CurrencyAmountValue"/>
                     *       &lt;xs:element ref="ns:PercentageValue"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private CurrencyAmountValue currencyAmountValue;
                        private PercentageValue percentageValue;

                        /** 
                         * Get the 'CurrencyAmountValue' element value.
                         * 
                         * @return value
                         */
                        public CurrencyAmountValue getCurrencyAmountValue() {
                            return currencyAmountValue;
                        }

                        /** 
                         * Set the 'CurrencyAmountValue' element value.
                         * 
                         * @param currencyAmountValue
                         */
                        public void setCurrencyAmountValue(
                                CurrencyAmountValue currencyAmountValue) {
                            this.currencyAmountValue = currencyAmountValue;
                        }

                        /** 
                         * Get the 'PercentageValue' element value.
                         * 
                         * @return value
                         */
                        public PercentageValue getPercentageValue() {
                            return percentageValue;
                        }

                        /** 
                         * Set the 'PercentageValue' element value.
                         * 
                         * @param percentageValue
                         */
                        public void setPercentageValue(
                                PercentageValue percentageValue) {
                            this.percentageValue = percentageValue;
                        }
                    }
                    /** 
                     * Association(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Passengers" minOccurs="0">
                     *         &lt;!-- Reference to inner class Passengers -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class OtherAssociation -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Associations implements Serializable
                    {
                        private Passengers passengers;
                        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                        /** 
                         * Get the 'Passengers' element value.
                         * 
                         * @return value
                         */
                        public Passengers getPassengers() {
                            return passengers;
                        }

                        /** 
                         * Set the 'Passengers' element value.
                         * 
                         * @param passengers
                         */
                        public void setPassengers(Passengers passengers) {
                            this.passengers = passengers;
                        }

                        /** 
                         * Get the list of 'OtherAssociation' element items.
                         * 
                         * @return list
                         */
                        public List<OtherAssociation> getOtherAssociationList() {
                            return otherAssociationList;
                        }

                        /** 
                         * Set the list of 'OtherAssociation' element items.
                         * 
                         * @param list
                         */
                        public void setOtherAssociationList(
                                List<OtherAssociation> list) {
                            otherAssociationList = list;
                        }
                        /** 
                         * Passenger(s)/ Group associated with the Offer Item.

                        Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element ref="ns:PassengerReferences"/>
                         *       &lt;xs:element ref="ns:GroupReference"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Passengers implements Serializable
                        {
                            private PassengerReferences passengerReferences;
                            private GroupReference groupReference;

                            /** 
                             * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                             * 
                             * @return value
                             */
                            public PassengerReferences getPassengerReferences() {
                                return passengerReferences;
                            }

                            /** 
                             * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                             * 
                             * @param passengerReferences
                             */
                            public void setPassengerReferences(
                                    PassengerReferences passengerReferences) {
                                this.passengerReferences = passengerReferences;
                            }

                            /** 
                             * Get the 'GroupReference' element value.
                             * 
                             * @return value
                             */
                            public GroupReference getGroupReference() {
                                return groupReference;
                            }

                            /** 
                             * Set the 'GroupReference' element value.
                             * 
                             * @param groupReference
                             */
                            public void setGroupReference(
                                    GroupReference groupReference) {
                                this.groupReference = groupReference;
                            }
                        }
                        /** 
                         * Other Named Association(s).

                        Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OtherAssociation implements
                            Serializable
                        {
                            private String type;
                            private String referenceValue;

                            /** 
                             * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'ReferenceValue' attribute value. Associated object instance value.
                            Example: mediaGroup1
                             * 
                             * @return value
                             */
                            public String getReferenceValue() {
                                return referenceValue;
                            }

                            /** 
                             * Set the 'ReferenceValue' attribute value. Associated object instance value.
                            Example: mediaGroup1
                             * 
                             * @param referenceValue
                             */
                            public void setReferenceValue(String referenceValue) {
                                this.referenceValue = referenceValue;
                            }
                        }
                    }
                }
            }
            /** 
             * Eligibility Exceptions, including passenger and promotion.

            Supports notifying seller systems of discrepency(s) with promotion or passenger pricing qualifiers specified in the order create transaction. If included in a response message, it may also include alternate offers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Eligibility" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Promotions" minOccurs="0">
             *         &lt;!-- Reference to inner class Promotions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Associations" minOccurs="0">
             *         &lt;!-- Reference to inner class Associations -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AlternateOffers" minOccurs="0">
             *         &lt;!-- Reference to inner class AlternateOffers -->
             *       &lt;/xs:element>
             *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="policy"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="References"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="objectMetaReferences"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="objectKey"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AltOfferInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PaxInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PromotionInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Eligibility implements Serializable
            {
                private Promotions promotions;
                private Associations associations;
                private AlternateOffers alternateOffers;
                private Remarks remarks;
                private String policy;
                private String references;
                private String objectMetaReferences;
                private String objectKey;
                private Boolean altOfferInd;
                private Boolean paxInd;
                private Boolean promotionInd;

                /** 
                 * Get the 'Promotions' element value.
                 * 
                 * @return value
                 */
                public Promotions getPromotions() {
                    return promotions;
                }

                /** 
                 * Set the 'Promotions' element value.
                 * 
                 * @param promotions
                 */
                public void setPromotions(Promotions promotions) {
                    this.promotions = promotions;
                }

                /** 
                 * Get the 'Associations' element value.
                 * 
                 * @return value
                 */
                public Associations getAssociations() {
                    return associations;
                }

                /** 
                 * Set the 'Associations' element value.
                 * 
                 * @param associations
                 */
                public void setAssociations(Associations associations) {
                    this.associations = associations;
                }

                /** 
                 * Get the 'AlternateOffers' element value.
                 * 
                 * @return value
                 */
                public AlternateOffers getAlternateOffers() {
                    return alternateOffers;
                }

                /** 
                 * Set the 'AlternateOffers' element value.
                 * 
                 * @param alternateOffers
                 */
                public void setAlternateOffers(AlternateOffers alternateOffers) {
                    this.alternateOffers = alternateOffers;
                }

                /** 
                 * Get the 'Remarks' element value.
                 * 
                 * @return value
                 */
                public Remarks getRemarks() {
                    return remarks;
                }

                /** 
                 * Set the 'Remarks' element value.
                 * 
                 * @param remarks
                 */
                public void setRemarks(Remarks remarks) {
                    this.remarks = remarks;
                }

                /** 
                 * Get the 'policy' attribute value. Associated Policy Reference(s). Example: pol1

                Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.This provides a method to indicate that the data in this element alone, or in combination with other elements, may be subject to an information management policy. As such, this attribute may contain a code to indicate that a message element contains sensitive data and may be subject to bilaterally agreed upon policies, etc.
                 * 
                 * @return value
                 */
                public String getPolicy() {
                    return policy;
                }

                /** 
                 * Set the 'policy' attribute value. Associated Policy Reference(s). Example: pol1

                Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.This provides a method to indicate that the data in this element alone, or in combination with other elements, may be subject to an information management policy. As such, this attribute may contain a code to indicate that a message element contains sensitive data and may be subject to bilaterally agreed upon policies, etc.
                 * 
                 * @param policy
                 */
                public void setPolicy(String policy) {
                    this.policy = policy;
                }

                /** 
                 * Get the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getReferences() {
                    return references;
                }

                /** 
                 * Set the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param references
                 */
                public void setReferences(String references) {
                    this.references = references;
                }

                /** 
                 * Get the 'objectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
                 * 
                 * @return value
                 */
                public String getObjectMetaReferences() {
                    return objectMetaReferences;
                }

                /** 
                 * Set the 'objectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
                 * 
                 * @param objectMetaReferences
                 */
                public void setObjectMetaReferences(String objectMetaReferences) {
                    this.objectMetaReferences = objectMetaReferences;
                }

                /** 
                 * Get the 'objectKey' attribute value. Object globally unique Instance ID. Example: obj1
                 * 
                 * @return value
                 */
                public String getObjectKey() {
                    return objectKey;
                }

                /** 
                 * Set the 'objectKey' attribute value. Object globally unique Instance ID. Example: obj1
                 * 
                 * @param objectKey
                 */
                public void setObjectKey(String objectKey) {
                    this.objectKey = objectKey;
                }

                /** 
                 * Get the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @return value
                 */
                public Boolean getAltOfferInd() {
                    return altOfferInd;
                }

                /** 
                 * Set the 'AltOfferInd' attribute value. When TRUE, alternate offers have been specified in the AlternateOffers node.
                 * 
                 * @param altOfferInd
                 */
                public void setAltOfferInd(Boolean altOfferInd) {
                    this.altOfferInd = altOfferInd;
                }

                /** 
                 * Get the 'PaxInd' attribute value. When TRUE, a passenger is ineligible for the offer.
                 * 
                 * @return value
                 */
                public Boolean getPaxInd() {
                    return paxInd;
                }

                /** 
                 * Set the 'PaxInd' attribute value. When TRUE, a passenger is ineligible for the offer.
                 * 
                 * @param paxInd
                 */
                public void setPaxInd(Boolean paxInd) {
                    this.paxInd = paxInd;
                }

                /** 
                 * Get the 'PromotionInd' attribute value. When TRUE, a promotion is invalid for the offer.
                 * 
                 * @return value
                 */
                public Boolean getPromotionInd() {
                    return promotionInd;
                }

                /** 
                 * Set the 'PromotionInd' attribute value. When TRUE, a promotion is invalid for the offer.
                 * 
                 * @param promotionInd
                 */
                public void setPromotionInd(Boolean promotionInd) {
                    this.promotionInd = promotionInd;
                }
                /** 
                 * In-eligible Promotion information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Promotions implements Serializable
                {
                    private List<PromotionType> promotionList = new ArrayList<PromotionType>();

                    /** 
                     * Get the list of 'Promotion' element items. Promotion Code.
                     * 
                     * @return list
                     */
                    public List<PromotionType> getPromotionList() {
                        return promotionList;
                    }

                    /** 
                     * Set the list of 'Promotion' element items. Promotion Code.
                     * 
                     * @param list
                     */
                    public void setPromotionList(List<PromotionType> list) {
                        promotionList = list;
                    }
                }
                /** 
                 * Association(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Passengers" minOccurs="0">
                 *         &lt;!-- Reference to inner class Passengers -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherAssociation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Associations implements Serializable
                {
                    private Passengers passengers;
                    private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }

                    /** 
                     * Get the list of 'OtherAssociation' element items.
                     * 
                     * @return list
                     */
                    public List<OtherAssociation> getOtherAssociationList() {
                        return otherAssociationList;
                    }

                    /** 
                     * Set the list of 'OtherAssociation' element items.
                     * 
                     * @param list
                     */
                    public void setOtherAssociationList(
                            List<OtherAssociation> list) {
                        otherAssociationList = list;
                    }
                    /** 
                     * Passenger(s)/ Groups associated with the Offer Item.

                    Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                    /** 
                     * Other Named Association(s).

                    Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherAssociation implements
                        Serializable
                    {
                        private String type;
                        private String referenceValue;

                        /** 
                         * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'ReferenceValue' attribute value. Associated object instance value.
                        Example: mediaGroup1
                         * 
                         * @return value
                         */
                        public String getReferenceValue() {
                            return referenceValue;
                        }

                        /** 
                         * Set the 'ReferenceValue' attribute value. Associated object instance value.
                        Example: mediaGroup1
                         * 
                         * @param referenceValue
                         */
                        public void setReferenceValue(String referenceValue) {
                            this.referenceValue = referenceValue;
                        }
                    }
                }
                /** 
                 * Alternate Offer(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="TotalOfferQuantity" minOccurs="0"/>
                 *       &lt;xs:element type="ns:AirlineID_Type" name="Owner"/>
                 *       &lt;xs:element name="AlternateOffer" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class AlternateOffer -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AlternateOffers implements Serializable
                {
                    private String totalOfferQuantity;
                    private AirlineIDType owner;
                    private List<AlternateOffer> alternateOfferList = new ArrayList<AlternateOffer>();

                    /** 
                     * Get the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                     * 
                     * @return value
                     */
                    public String getTotalOfferQuantity() {
                        return totalOfferQuantity;
                    }

                    /** 
                     * Set the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
                     * 
                     * @param totalOfferQuantity
                     */
                    public void setTotalOfferQuantity(String totalOfferQuantity) {
                        this.totalOfferQuantity = totalOfferQuantity;
                    }

                    /** 
                     * Get the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @return value
                     */
                    public AirlineIDType getOwner() {
                        return owner;
                    }

                    /** 
                     * Set the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @param owner
                     */
                    public void setOwner(AirlineIDType owner) {
                        this.owner = owner;
                    }

                    /** 
                     * Get the list of 'AlternateOffer' element items.
                     * 
                     * @return list
                     */
                    public List<AlternateOffer> getAlternateOfferList() {
                        return alternateOfferList;
                    }

                    /** 
                     * Set the list of 'AlternateOffer' element items.
                     * 
                     * @param list
                     */
                    public void setAlternateOfferList(List<AlternateOffer> list) {
                        alternateOfferList = list;
                    }
                    /** 
                     * Airline Alternate Offer Detail.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffer" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:complexContent>
                     *       &lt;xs:extension base="ns:OfferItemDetailType">
                     *         &lt;xs:sequence>
                     *           &lt;xs:element ref="ns:AltBaggageOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltPricedFlightOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltOtherOffer" minOccurs="0"/>
                     *           &lt;xs:element ref="ns:AltSeatOffer" minOccurs="0"/>
                     *         &lt;/xs:sequence>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:complexContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AlternateOffer
                            extends
                                OfferItemDetailType implements Serializable
                    {
                        private AltBaggageOfferType altBaggageOffer;
                        private AltPricedFlightOfferType altPricedFlightOffer;
                        private AltOtherOfferType altOtherOffer;
                        private AltSeatOfferType altSeatOffer;

                        /** 
                         * Get the 'AltBaggageOffer' element value.
                         * 
                         * @return value
                         */
                        public AltBaggageOfferType getAltBaggageOffer() {
                            return altBaggageOffer;
                        }

                        /** 
                         * Set the 'AltBaggageOffer' element value.
                         * 
                         * @param altBaggageOffer
                         */
                        public void setAltBaggageOffer(
                                AltBaggageOfferType altBaggageOffer) {
                            this.altBaggageOffer = altBaggageOffer;
                        }

                        /** 
                         * Get the 'AltPricedFlightOffer' element value.
                         * 
                         * @return value
                         */
                        public AltPricedFlightOfferType getAltPricedFlightOffer() {
                            return altPricedFlightOffer;
                        }

                        /** 
                         * Set the 'AltPricedFlightOffer' element value.
                         * 
                         * @param altPricedFlightOffer
                         */
                        public void setAltPricedFlightOffer(
                                AltPricedFlightOfferType altPricedFlightOffer) {
                            this.altPricedFlightOffer = altPricedFlightOffer;
                        }

                        /** 
                         * Get the 'AltOtherOffer' element value.
                         * 
                         * @return value
                         */
                        public AltOtherOfferType getAltOtherOffer() {
                            return altOtherOffer;
                        }

                        /** 
                         * Set the 'AltOtherOffer' element value.
                         * 
                         * @param altOtherOffer
                         */
                        public void setAltOtherOffer(
                                AltOtherOfferType altOtherOffer) {
                            this.altOtherOffer = altOtherOffer;
                        }

                        /** 
                         * Get the 'AltSeatOffer' element value.
                         * 
                         * @return value
                         */
                        public AltSeatOfferType getAltSeatOffer() {
                            return altSeatOffer;
                        }

                        /** 
                         * Set the 'AltSeatOffer' element value.
                         * 
                         * @param altSeatOffer
                         */
                        public void setAltSeatOffer(
                                AltSeatOfferType altSeatOffer) {
                            this.altSeatOffer = altSeatOffer;
                        }
                    }
                }
            }
        }
    }
}
