
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopNoticesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:NoticeBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="AppliedTaxExemption" minOccurs="0">
 *           &lt;!-- Reference to inner class AppliedTaxExemption -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="AppliedPriceVariance" minOccurs="0">
 *           &lt;!-- Reference to inner class AppliedPriceVariance -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItinReshopNoticesType extends NoticeBaseType implements
    Serializable
{
    private AppliedTaxExemption appliedTaxExemption;
    private AppliedPriceVariance appliedPriceVariance;

    /** 
     * Get the 'AppliedTaxExemption' element value.
     * 
     * @return value
     */
    public AppliedTaxExemption getAppliedTaxExemption() {
        return appliedTaxExemption;
    }

    /** 
     * Set the 'AppliedTaxExemption' element value.
     * 
     * @param appliedTaxExemption
     */
    public void setAppliedTaxExemption(AppliedTaxExemption appliedTaxExemption) {
        this.appliedTaxExemption = appliedTaxExemption;
    }

    /** 
     * Get the 'AppliedPriceVariance' element value.
     * 
     * @return value
     */
    public AppliedPriceVariance getAppliedPriceVariance() {
        return appliedPriceVariance;
    }

    /** 
     * Set the 'AppliedPriceVariance' element value.
     * 
     * @param appliedPriceVariance
     */
    public void setAppliedPriceVariance(
            AppliedPriceVariance appliedPriceVariance) {
        this.appliedPriceVariance = appliedPriceVariance;
    }
    /** 
     * Applied Tax/ Fee Exemption Notice.

    Note: Supports notification to receiving system that tax/ fee exemptions are requested during transaction processing, and, if and how the exemptions were applied to message results.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AppliedTaxExemption" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TaxExemption" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TaxExemption -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExemptionAppliedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AppliedTaxExemption implements Serializable
    {
        private List<TaxExemption> taxExemptionList = new ArrayList<TaxExemption>();
        private Boolean exemptionAppliedInd;

        /** 
         * Get the list of 'TaxExemption' element items.
         * 
         * @return list
         */
        public List<TaxExemption> getTaxExemptionList() {
            return taxExemptionList;
        }

        /** 
         * Set the list of 'TaxExemption' element items.
         * 
         * @param list
         */
        public void setTaxExemptionList(List<TaxExemption> list) {
            taxExemptionList = list;
        }

        /** 
         * Get the 'ExemptionAppliedInd' attribute value. When TRUE, a tax/ fee exemption was applied to the total order price or one or more priced Order Items.
         * 
         * @return value
         */
        public Boolean getExemptionAppliedInd() {
            return exemptionAppliedInd;
        }

        /** 
         * Set the 'ExemptionAppliedInd' attribute value. When TRUE, a tax/ fee exemption was applied to the total order price or one or more priced Order Items.
         * 
         * @param exemptionAppliedInd
         */
        public void setExemptionAppliedInd(Boolean exemptionAppliedInd) {
            this.exemptionAppliedInd = exemptionAppliedInd;
        }
        /** 
         * Applied Tax Exemption(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExemption" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RuleID" minOccurs="0">
         *         &lt;!-- Reference to inner class RuleID -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Associations" minOccurs="0">
         *         &lt;!-- Reference to inner class Associations -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TaxExemption implements Serializable
        {
            private RuleID ruleID;
            private Associations associations;
            private String trxItemKey;

            /** 
             * Get the 'RuleID' element value.
             * 
             * @return value
             */
            public RuleID getRuleID() {
                return ruleID;
            }

            /** 
             * Set the 'RuleID' element value.
             * 
             * @param ruleID
             */
            public void setRuleID(RuleID ruleID) {
                this.ruleID = ruleID;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
             * 
             * @return value
             */
            public String getTrxItemKey() {
                return trxItemKey;
            }

            /** 
             * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
             * 
             * @param trxItemKey
             */
            public void setTrxItemKey(String trxItemKey) {
                this.trxItemKey = trxItemKey;
            }
            /** 
             * Applied Rule ID.
            Example: PRICERULE001
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleID implements Serializable
            {
                private String string;
                private String context;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Rule ID Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Rule ID Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }

                /** 
                 * Get the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
            /** 
             * Association(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="OfferSetReferences" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="Passengers" minOccurs="0">
             *         &lt;!-- Reference to inner class Passengers -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherAssociation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Associations implements Serializable
            {
                private String offerSetReferences;
                private List<OfferItemID> offerItemIDList = new ArrayList<OfferItemID>();
                private Passengers passengers;
                private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                /** 
                 * Get the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @return value
                 */
                public String getOfferSetReferences() {
                    return offerSetReferences;
                }

                /** 
                 * Set the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @param offerSetReferences
                 */
                public void setOfferSetReferences(String offerSetReferences) {
                    this.offerSetReferences = offerSetReferences;
                }

                /** 
                 * Get the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @return list
                 */
                public List<OfferItemID> getOfferItemIDList() {
                    return offerItemIDList;
                }

                /** 
                 * Set the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @param list
                 */
                public void setOfferItemIDList(List<OfferItemID> list) {
                    offerItemIDList = list;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }

                /** 
                 * Get the list of 'OtherAssociation' element items.
                 * 
                 * @return list
                 */
                public List<OtherAssociation> getOtherAssociationList() {
                    return otherAssociationList;
                }

                /** 
                 * Set the list of 'OtherAssociation' element items.
                 * 
                 * @param list
                 */
                public void setOtherAssociationList(List<OtherAssociation> list) {
                    otherAssociationList = list;
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        this.groupReference = groupReference;
                    }
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediaGroup1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediaGroup1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
        }
    }
    /** 
     * Applied Price Variance Rule(s) Notice.

    Note: Supports specifying the acceptable amount and/or percentage of the total amount by which the Order item price can vary from the Offer price for Order creation to proceed, for example to cover minor currency exchange rate fluctuations for taxes quoted in a different currency. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AppliedPriceVariance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceVariance -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="VarianceAppliedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AppliedPriceVariance implements Serializable
    {
        private List<PriceVariance> priceVarianceList = new ArrayList<PriceVariance>();
        private Boolean varianceAppliedInd;

        /** 
         * Get the list of 'PriceVariance' element items.
         * 
         * @return list
         */
        public List<PriceVariance> getPriceVarianceList() {
            return priceVarianceList;
        }

        /** 
         * Set the list of 'PriceVariance' element items.
         * 
         * @param list
         */
        public void setPriceVarianceList(List<PriceVariance> list) {
            priceVarianceList = list;
        }

        /** 
         * Get the 'VarianceAppliedInd' attribute value. When TRUE, a pricing variant was applied to the total order price or one or more priced Order Items.
         * 
         * @return value
         */
        public Boolean getVarianceAppliedInd() {
            return varianceAppliedInd;
        }

        /** 
         * Set the 'VarianceAppliedInd' attribute value. When TRUE, a pricing variant was applied to the total order price or one or more priced Order Items.
         * 
         * @param varianceAppliedInd
         */
        public void setVarianceAppliedInd(Boolean varianceAppliedInd) {
            this.varianceAppliedInd = varianceAppliedInd;
        }
        /** 
         * Applied Price Variance Rule(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RuleID" minOccurs="0">
         *         &lt;!-- Reference to inner class RuleID -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Amount">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element ref="ns:CurrencyAmountValue"/>
         *             &lt;xs:element ref="ns:PercentageValue"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Associations" minOccurs="0">
         *         &lt;!-- Reference to inner class Associations -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceVariance implements Serializable
        {
            private RuleID ruleID;
            private CurrencyAmountValue amountCurrencyAmountValue;
            private PercentageValue amountPercentageValue;
            private Associations associations;
            private String trxItemKey;

            /** 
             * Get the 'RuleID' element value.
             * 
             * @return value
             */
            public RuleID getRuleID() {
                return ruleID;
            }

            /** 
             * Set the 'RuleID' element value.
             * 
             * @param ruleID
             */
            public void setRuleID(RuleID ruleID) {
                this.ruleID = ruleID;
            }

            /** 
             * Get the 'CurrencyAmountValue' element value.
             * 
             * @return value
             */
            public CurrencyAmountValue getAmountCurrencyAmountValue() {
                return amountCurrencyAmountValue;
            }

            /** 
             * Set the 'CurrencyAmountValue' element value.
             * 
             * @param amountCurrencyAmountValue
             */
            public void setAmountCurrencyAmountValue(
                    CurrencyAmountValue amountCurrencyAmountValue) {
                this.amountCurrencyAmountValue = amountCurrencyAmountValue;
            }

            /** 
             * Get the 'PercentageValue' element value.
             * 
             * @return value
             */
            public PercentageValue getAmountPercentageValue() {
                return amountPercentageValue;
            }

            /** 
             * Set the 'PercentageValue' element value.
             * 
             * @param amountPercentageValue
             */
            public void setAmountPercentageValue(
                    PercentageValue amountPercentageValue) {
                this.amountPercentageValue = amountPercentageValue;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
             * 
             * @return value
             */
            public String getTrxItemKey() {
                return trxItemKey;
            }

            /** 
             * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
             * 
             * @param trxItemKey
             */
            public void setTrxItemKey(String trxItemKey) {
                this.trxItemKey = trxItemKey;
            }
            /** 
             * Applied Rule ID.
            Example: PRICERULE001
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleID implements Serializable
            {
                private String string;
                private String context;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Rule ID Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Rule ID Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }

                /** 
                 * Get the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
            /** 
             * Association(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="OfferSetReferences" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="Passengers" minOccurs="0">
             *         &lt;!-- Reference to inner class Passengers -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherAssociation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Associations implements Serializable
            {
                private String offerSetReferences;
                private List<OfferItemID> offerItemIDList = new ArrayList<OfferItemID>();
                private Passengers passengers;
                private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                /** 
                 * Get the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @return value
                 */
                public String getOfferSetReferences() {
                    return offerSetReferences;
                }

                /** 
                 * Set the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @param offerSetReferences
                 */
                public void setOfferSetReferences(String offerSetReferences) {
                    this.offerSetReferences = offerSetReferences;
                }

                /** 
                 * Get the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @return list
                 */
                public List<OfferItemID> getOfferItemIDList() {
                    return offerItemIDList;
                }

                /** 
                 * Set the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @param list
                 */
                public void setOfferItemIDList(List<OfferItemID> list) {
                    offerItemIDList = list;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }

                /** 
                 * Get the list of 'OtherAssociation' element items.
                 * 
                 * @return list
                 */
                public List<OtherAssociation> getOtherAssociationList() {
                    return otherAssociationList;
                }

                /** 
                 * Set the list of 'OtherAssociation' element items.
                 * 
                 * @param list
                 */
                public void setOtherAssociationList(List<OtherAssociation> list) {
                    otherAssociationList = list;
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        this.groupReference = groupReference;
                    }
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediaGroup1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediaGroup1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediaGroup1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
        }
    }
}
