
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * LEAD DATE PERIOD representation.

 Notes: Supports Calendar Shopping. Days, Months, etc. before and/ or after the specified date.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadDatePeriodType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:attribute type="xs:string" use="optional" name="Before"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="After"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LeadDatePeriodType extends AssociatedObjectBaseType implements
    Serializable
{
    private String before;
    private String after;

    /** 
     * Get the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @return value
     */
    public String getBefore() {
        return before;
    }

    /** 
     * Set the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @param before
     */
    public void setBefore(String before) {
        this.before = before;
    }

    /** 
     * Get the 'After' attribute value. The period duration to be applied AFTER the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @return value
     */
    public String getAfter() {
        return after;
    }

    /** 
     * Set the 'After' attribute value. The period duration to be applied AFTER the specified date.  Examples: 
    P3D (three days)
    P7D (seven days)
     * 
     * @param after
     */
    public void setAfter(String after) {
        this.after = after;
    }
}
