
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * A base type definition for Data List Object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListBaseType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="ListToken"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListBaseType implements Serializable
{
    private String listToken;
    private String owner;
    private BigInteger seq;

    /** 
     * Get the 'ListToken' attribute value. Unique List Token.

    Example: jZhJu7SORZeO MNpifElIkA

    Note: This token pertains to all specified List instances, e.g. the list collection.
     * 
     * @return value
     */
    public String getListToken() {
        return listToken;
    }

    /** 
     * Set the 'ListToken' attribute value. Unique List Token.

    Example: jZhJu7SORZeO MNpifElIkA

    Note: This token pertains to all specified List instances, e.g. the list collection.
     * 
     * @param listToken
     */
    public void setListToken(String listToken) {
        this.listToken = listToken;
    }

    /** 
     * Get the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @return value
     */
    public BigInteger getSeq() {
        return seq;
    }

    /** 
     * Set the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @param seq
     */
    public void setSeq(BigInteger seq) {
        this.seq = seq;
    }
}
