
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CARRY-ON ALLOWANCE data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfCarryOnAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CarryOnAllowance" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class CarryOnAllowance -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfCarryOnAllowanceType implements Serializable
{
    private List<CarryOnAllowance> carryOnAllowanceList = new ArrayList<CarryOnAllowance>();

    /** 
     * Get the list of 'CarryOnAllowance' element items.
     * 
     * @return list
     */
    public List<CarryOnAllowance> getCarryOnAllowanceList() {
        return carryOnAllowanceList;
    }

    /** 
     * Set the list of 'CarryOnAllowance' element items.
     * 
     * @param list
     */
    public void setCarryOnAllowanceList(List<CarryOnAllowance> list) {
        carryOnAllowanceList = list;
    }
    /** 
     * Carry-on Allowance detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarryOnAllowance" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
     *           &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
     *           &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CarryOnAllowance extends DataListObjectBaseType
        implements Serializable
    {
        private BagAllowanceDescType allowanceDescription;
        private BagAllowanceDimensionType dimensionAllowance;
        private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
        private WeightAllowance weightAllowance;

        /** 
         * Get the 'AllowanceDescription' element value.
         * 
         * @return value
         */
        public BagAllowanceDescType getAllowanceDescription() {
            return allowanceDescription;
        }

        /** 
         * Set the 'AllowanceDescription' element value.
         * 
         * @param allowanceDescription
         */
        public void setAllowanceDescription(
                BagAllowanceDescType allowanceDescription) {
            this.allowanceDescription = allowanceDescription;
        }

        /** 
         * Get the 'DimensionAllowance' element value.
         * 
         * @return value
         */
        public BagAllowanceDimensionType getDimensionAllowance() {
            return dimensionAllowance;
        }

        /** 
         * Set the 'DimensionAllowance' element value.
         * 
         * @param dimensionAllowance
         */
        public void setDimensionAllowance(
                BagAllowanceDimensionType dimensionAllowance) {
            this.dimensionAllowance = dimensionAllowance;
        }

        /** 
         * Get the list of 'PieceAllowance' element items.
         * 
         * @return list
         */
        public List<BagAllowancePieceType> getPieceAllowanceList() {
            return pieceAllowanceList;
        }

        /** 
         * Set the list of 'PieceAllowance' element items.
         * 
         * @param list
         */
        public void setPieceAllowanceList(List<BagAllowancePieceType> list) {
            pieceAllowanceList = list;
        }

        /** 
         * Get the 'WeightAllowance' element value.
         * 
         * @return value
         */
        public WeightAllowance getWeightAllowance() {
            return weightAllowance;
        }

        /** 
         * Set the 'WeightAllowance' element value.
         * 
         * @param weightAllowance
         */
        public void setWeightAllowance(WeightAllowance weightAllowance) {
            this.weightAllowance = weightAllowance;
        }
    }
}
