
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a list of Classes of Service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfClassOfServiceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ServiceClass" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class ServiceClass -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfClassOfServiceType implements Serializable
{
    private List<ServiceClass> serviceClassList = new ArrayList<ServiceClass>();

    /** 
     * Get the list of 'ServiceClass' element items.
     * 
     * @return list
     */
    public List<ServiceClass> getServiceClassList() {
        return serviceClassList;
    }

    /** 
     * Set the list of 'ServiceClass' element items.
     * 
     * @param list
     */
    public void setServiceClassList(List<ServiceClass> list) {
        serviceClassList = list;
    }
    /** 
     * Class of Service.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceClass" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
     *           &lt;xs:element type="xs:string" name="MarketingName" minOccurs="0"/>
     *           &lt;xs:element type="ns:COS_OtherAssocType" name="Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceClass extends DataListObjectBaseType implements
        Serializable
    {
        private String code;
        private String marketingName;
        private COSOtherAssocType associations;

        /** 
         * Get the 'Code' element value. Class of Service. Example: T
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Class of Service. Example: T
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'MarketingName' element value. Name. Example: Economy
         * 
         * @return value
         */
        public String getMarketingName() {
            return marketingName;
        }

        /** 
         * Set the 'MarketingName' element value. Name. Example: Economy
         * 
         * @param marketingName
         */
        public void setMarketingName(String marketingName) {
            this.marketingName = marketingName;
        }

        /** 
         * Get the 'Associations' element value. Class of Service Association(s).
         * 
         * @return value
         */
        public COSOtherAssocType getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. Class of Service Association(s).
         * 
         * @param associations
         */
        public void setAssociations(COSOtherAssocType associations) {
            this.associations = associations;
        }
    }
}
