
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CONTENT SOURCE data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfContentSourceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ContentSource" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class ContentSource -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfContentSourceType implements Serializable
{
    private List<ContentSource> contentSourceList = new ArrayList<ContentSource>();

    /** 
     * Get the list of 'ContentSource' element items.
     * 
     * @return list
     */
    public List<ContentSource> getContentSourceList() {
        return contentSourceList;
    }

    /** 
     * Set the list of 'ContentSource' element items.
     * 
     * @param list
     */
    public void setContentSourceList(List<ContentSource> list) {
        contentSourceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContentSource" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="NodePath"/>
     *           &lt;xs:choice>
     *             &lt;xs:element ref="ns:AirlineID"/>
     *             &lt;xs:element name="OtherID">
     *               &lt;xs:complexType>
     *                 &lt;xs:simpleContent>
     *                   &lt;xs:extension base="xs:string">
     *                     &lt;xs:attribute type="xs:string" use="optional" name="name"/>
     *                   &lt;/xs:extension>
     *                 &lt;/xs:simpleContent>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:choice>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ContentSource extends DataListObjectBaseType implements
        Serializable
    {
        private String nodePath;
        private int choiceSelect = -1;
        private static final int AIRLINE_ID_CHOICE = 0;
        private static final int OTHER_ID_CHOICE = 1;
        private AirlineIDType airlineID;
        private String otherIDString;
        private String otherIDName;

        /** 
         * Get the 'NodePath' element value. XPath to element or attribute in the message.
        Encoding Scheme: W3C xPath Notation
         * 
         * @return value
         */
        public String getNodePath() {
            return nodePath;
        }

        /** 
         * Set the 'NodePath' element value. XPath to element or attribute in the message.
        Encoding Scheme: W3C xPath Notation
         * 
         * @param nodePath
         */
        public void setNodePath(String nodePath) {
            this.nodePath = nodePath;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AirlineID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirlineID() {
            return choiceSelect == AIRLINE_ID_CHOICE;
        }

        /** 
         * Get the 'AirlineID' element value.
         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value.
         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            setChoiceSelect(AIRLINE_ID_CHOICE);
            this.airlineID = airlineID;
        }

        /** 
         * Check if OtherID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOtherID() {
            return choiceSelect == OTHER_ID_CHOICE;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getOtherIDString() {
            return otherIDString;
        }

        /** 
         * Set the extension value.
         * 
         * @param otherIDString
         */
        public void setOtherIDString(String otherIDString) {
            setChoiceSelect(OTHER_ID_CHOICE);
            this.otherIDString = otherIDString;
        }

        /** 
         * Get the 'name' attribute value. Other ID name.
        Example: Datalex
         * 
         * @return value
         */
        public String getOtherIDName() {
            return otherIDName;
        }

        /** 
         * Set the 'name' attribute value. Other ID name.
        Example: Datalex
         * 
         * @param otherIDName
         */
        public void setOtherIDName(String otherIDName) {
            setChoiceSelect(OTHER_ID_CHOICE);
            this.otherIDName = otherIDName;
        }
    }
}
