
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * DISCLOSURE data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfDisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Disclosures" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Disclosures -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfDisclosureType implements Serializable
{
    private List<Disclosures> disclosureList = new ArrayList<Disclosures>();

    /** 
     * Get the list of 'Disclosures' element items.
     * 
     * @return list
     */
    public List<Disclosures> getDisclosureList() {
        return disclosureList;
    }

    /** 
     * Set the list of 'Disclosures' element items.
     * 
     * @param list
     */
    public void setDisclosureList(List<Disclosures> list) {
        disclosureList = list;
    }
    /** 
     * Disclosure Description or Link.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Disclosures" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:DescriptionType" name="Description" maxOccurs="unbounded"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Disclosures extends DataListObjectBaseType implements
        Serializable
    {
        private List<DescriptionType> descriptionList = new ArrayList<DescriptionType>();

        /** 
         * Get the list of 'Description' element items. Plain Text or Rich Media Disclosure Description(s).
         * 
         * @return list
         */
        public List<DescriptionType> getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the list of 'Description' element items. Plain Text or Rich Media Disclosure Description(s).
         * 
         * @param list
         */
        public void setDescriptionList(List<DescriptionType> list) {
            descriptionList = list;
        }
    }
}
