
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Marketing Message Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketMsgAssocType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Association" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Association -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MarketMsgAssocType extends AssociatedObjectBaseType implements
    Serializable
{
    private List<Association> associationList = new ArrayList<Association>();

    /** 
     * Get the list of 'Association' element items.
     * 
     * @return list
     */
    public List<Association> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Association' element items.
     * 
     * @param list
     */
    public void setAssociationList(List<Association> list) {
        associationList = list;
    }
    /** 
     * General Marketing Message Association Detail.

    Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Association" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Type"/>
     *       &lt;xs:element type="xs:string" name="ReferenceValue"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Association implements Serializable
    {
        private String type;
        private String referenceValue;

        /** 
         * Get the 'Type' element value. Named association type. Examples: Equipment, MediaGroup
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Named association type. Examples: Equipment, MediaGroup
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @return value
         */
        public String getReferenceValue() {
            return referenceValue;
        }

        /** 
         * Set the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @param referenceValue
         */
        public void setReferenceValue(String referenceValue) {
            this.referenceValue = referenceValue;
        }
    }
}
